/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.osgi.web.servlet.JSPServletFactory;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.JspServlet;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.servlet.Servlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.VersionRange;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={JSPServletFactory.class})
public class JSPServletFactoryImpl
implements JSPServletFactory {
    private static final String _DIR_NAME_RESOURCES = "/META-INF/resources";
    private static final String _WORK_DIR = StringBundler.concat((String[])new String[]{PropsValues.LIFERAY_HOME, File.separator, "work", File.separator});
    private static final Log _log = LogFactoryUtil.getLog(JSPServletFactoryImpl.class);
    private BundleTracker<Tracked> _bundleTracker;

    public Servlet createJSPServlet() {
        return new JspServlet();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 4, (BundleTrackerCustomizer)new JspFragmentBundleTrackerCustomizer(bundleContext));
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private static class Tracked {
        private final String _symbolicName;
        private final VersionRange _versionRange;

        public boolean match(Bundle bundle) {
            return this._symbolicName.equals(bundle.getSymbolicName()) && (this._versionRange == null || this._versionRange.includes(bundle.getVersion()));
        }

        private Tracked(String symbolicName, VersionRange versionRange) {
            this._symbolicName = symbolicName;
            this._versionRange = versionRange;
        }
    }

    private static class JspFragmentBundleTrackerCustomizer
    implements BundleTrackerCustomizer<Tracked> {
        private final BundleContext _bundleContext;

        public Tracked addingBundle(Bundle bundle, BundleEvent event) {
            Dictionary headers = bundle.getHeaders("");
            String fragmentHost = (String)headers.get("Fragment-Host");
            if (fragmentHost == null) {
                return null;
            }
            Enumeration enumeration = bundle.findEntries(JSPServletFactoryImpl._DIR_NAME_RESOURCES, "*.jsp*", true);
            if (enumeration == null) {
                return null;
            }
            String[] fragmentHostParts = StringUtil.split((String)fragmentHost, (char)';');
            String symbolicName = StringUtil.trim((String)fragmentHostParts[0]);
            VersionRange versionRange = null;
            if (fragmentHostParts.length > 1) {
                String[] versionParts = StringUtil.split((String)fragmentHostParts[1], (char)'=');
                versionRange = new VersionRange(StringUtil.unquote((String)StringUtil.trim((String)versionParts[1])));
            }
            Tracked tracked = new Tracked(symbolicName, versionRange);
            this._deleteJSPServletClasses(tracked);
            return tracked;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Tracked tracked) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Tracked tracked) {
            this._deleteJSPServletClasses(tracked);
        }

        private JspFragmentBundleTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        private void _deleteJSPServletClasses(Tracked tracked) {
            for (Bundle bundle : this._bundleContext.getBundles()) {
                if (!tracked.match(bundle)) continue;
                StringBundler sb = new StringBundler(4);
                sb.append(_WORK_DIR);
                sb.append(bundle.getSymbolicName());
                sb.append("-");
                sb.append((Object)bundle.getVersion());
                String scratchDir = sb.toString();
                if (PropsValues.WORK_DIR_OVERRIDE_ENABLED && _log.isInfoEnabled()) {
                    _log.info((Object)"Deleting JSP class files from ".concat(scratchDir));
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Deleting JSP class files from ".concat(scratchDir));
                }
                FileUtil.deltree((File)new File(scratchDir));
            }
        }
    }
}

