/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.BaseJavaFileObject;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.JavaFileObjectResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class BundleJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    public static final String OPT_VERBOSE = "-verbose";
    private static final Log _log = LogFactoryUtil.getLog(BundleJavaFileManager.class);
    private static final Set<JavaFileObject.Kind> _kinds = EnumSet.of(JavaFileObject.Kind.CLASS);
    private final ClassLoader _classLoader;
    private final List<JavaFileObjectResolver> _javaFileObjectResolvers;

    public BundleJavaFileManager(ClassLoader classLoader, JavaFileManager javaFileManager, List<JavaFileObjectResolver> javaFileObjectResolvers) {
        super(javaFileManager);
        this._classLoader = classLoader;
        this._javaFileObjectResolvers = javaFileObjectResolvers;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (location != StandardLocation.CLASS_PATH) {
            return this.fileManager.getClassLoader(location);
        }
        return this._classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.CLASS_PATH && file instanceof BaseJavaFileObject) {
            BaseJavaFileObject baseJavaFileObject = (BaseJavaFileObject)file;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Inferring binary name from " + baseJavaFileObject));
            }
            return baseJavaFileObject.getClassName();
        }
        return this.fileManager.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (!kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            return Collections.emptyList();
        }
        if (location == StandardLocation.CLASS_PATH && _log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(9);
            sb.append("List for {kinds=");
            sb.append(_kinds);
            sb.append(", location=");
            sb.append((Object)location);
            sb.append(", packageName=");
            sb.append(packageName);
            sb.append(", recurse=");
            sb.append(recurse);
            sb.append("}");
            _log.info((Object)sb.toString());
        }
        String packagePath = StringUtil.replace((String)packageName, (char)'.', (char)'/');
        if (!packageName.startsWith("java.") && location == StandardLocation.CLASS_PATH) {
            for (JavaFileObjectResolver javaFileObjectResolver : this._javaFileObjectResolvers) {
                Collection<JavaFileObject> javaFileObjects = javaFileObjectResolver.resolveClasses(recurse, packagePath);
                if (javaFileObjects.isEmpty()) continue;
                return javaFileObjects;
            }
        }
        return this.fileManager.list(location, packagePath, _kinds, recurse);
    }
}

