/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.runtime.TagHandlerPool;

public class JspTagHandlerPool
extends TagHandlerPool {
    private final AtomicInteger _counter = new AtomicInteger();
    private final Queue<JspTag> _jspTags = new ConcurrentLinkedQueue<JspTag>();
    private int _maxSize;

    public <T extends JspTag> JspTag get(Class<T> jspTagClass) throws JspException {
        JspTag jspTag = this._jspTags.poll();
        if (jspTag == null) {
            try {
                jspTag = (JspTag)jspTagClass.newInstance();
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        } else {
            this._counter.getAndDecrement();
        }
        return jspTag;
    }

    public void release() {
        JspTag jspTag = null;
        while ((jspTag = this._jspTags.poll()) != null) {
            if (!(jspTag instanceof Tag)) continue;
            Tag tag = (Tag)jspTag;
            tag.release();
        }
    }

    public void reuse(JspTag jspTag) {
        if (this._counter.get() < this._maxSize) {
            this._counter.getAndIncrement();
            this._jspTags.offer(jspTag);
        } else if (jspTag instanceof Tag) {
            Tag tag = (Tag)jspTag;
            tag.release();
        }
    }

    protected void init(ServletConfig config) {
        this._maxSize = GetterUtil.getInteger((String)JspTagHandlerPool.getOption((ServletConfig)config, (String)"tagpoolMaxSize", null), (int)5);
    }
}

