/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={})
public class JspReloader {
    private static final String _WORK_DIR = StringBundler.concat((String[])new String[]{PropsValues.LIFERAY_HOME, File.separator, "work", File.separator});
    private static final Log _log = LogFactoryUtil.getLog(JspReloader.class);
    private BundleContext _bundleContext;
    private final BundleListener _jspReloadBundleListener = new BundleListener(){

        public void bundleChanged(BundleEvent bundleEvent) {
            int type = bundleEvent.getType();
            if (type != 8 && type != 16) {
                return;
            }
            Bundle bundle = bundleEvent.getBundle();
            File file = new File(_WORK_DIR, bundle.getSymbolicName() + "-" + bundle.getVersion());
            if (file.exists()) {
                FileUtil.deltree((File)file);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Removed Jasper work dir ", file, " on event ", JspReloader._toString(bundleEvent)}));
                }
            }
        }
    };

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._bundleContext.addBundleListener(this._jspReloadBundleListener);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleContext.removeBundleListener(this._jspReloadBundleListener);
    }

    private static String _toString(BundleEvent bundleEvent) {
        StringBundler sb = new StringBundler(6);
        sb.append("{bundle=");
        sb.append((Object)bundleEvent.getBundle());
        sb.append(", origin=");
        sb.append((Object)bundleEvent.getOrigin());
        sb.append(", type=");
        if (8 == bundleEvent.getType()) {
            sb.append("UPDATED}");
        } else {
            sb.append("UNINSTALLED}");
        }
        return sb.toString();
    }
}

