/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.JspBundleClassloader;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.JspServletContext;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.JspTagHandlerPool;
import com.liferay.portal.servlet.delegate.ServletContextDelegate;
import com.liferay.portal.util.PropsValues;
import com.liferay.taglib.servlet.JspFactorySwapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspFactory;
import org.apache.felix.utils.log.Logger;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class JspServlet
extends HttpServlet {
    private static final String _DIR_NAME_RESOURCES = "/META-INF/resources";
    private static final String _INIT_PARAMETER_NAME_SCRATCH_DIR = "scratchdir";
    private static final Class<?>[] _INTERFACES = new Class[]{JspServletContext.class, ServletContext.class};
    private static final String _WORK_DIR = StringBundler.concat((String[])new String[]{PropsValues.LIFERAY_HOME, File.separator, "work", File.separator});
    private static final Map<Method, Method> _contextAdapterMethods;
    private static final Properties _initParams;
    private static final Bundle _jspBundle;
    private static final Pattern _originalJspPattern;
    private Bundle[] _allParticipatingBundles;
    private Bundle _bundle;
    private BundleTracker<List<Path>> _bundleTracker;
    private JspBundleClassloader _jspBundleClassloader;
    private final HttpServlet _jspServlet = new org.apache.jasper.servlet.JspServlet();
    private Logger _logger;
    private boolean _logVerbosityLevelDebug;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new CopyOnWriteArrayList();

    public void destroy() {
        this._jspServlet.destroy();
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
        this._bundleTracker.close();
    }

    public boolean equals(Object obj) {
        return this._jspServlet.equals(obj);
    }

    public String getInitParameter(String name) {
        return this._jspServlet.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this._jspServlet.getInitParameterNames();
    }

    public ServletConfig getServletConfig() {
        return this._jspServlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this._jspServlet.getServletContext();
    }

    public String getServletInfo() {
        return this._jspServlet.getServletInfo();
    }

    public String getServletName() {
        return this._jspServlet.getServletName();
    }

    public int hashCode() {
        return this._jspServlet.hashCode();
    }

    public void init() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(final ServletConfig servletConfig) throws ServletException {
        final ServletContext servletContext = ServletContextDelegate.create((ServletContext)servletConfig.getServletContext());
        ClassLoader classLoader = servletContext.getClassLoader();
        if (!(classLoader instanceof BundleReference)) {
            throw new IllegalStateException();
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
            JspFactorySwapper.swap();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        BundleReference bundleReference = (BundleReference)classLoader;
        this._bundle = bundleReference.getBundle();
        bundles.add(this._bundle);
        bundles.add(_jspBundle);
        this._logger = new Logger(this._bundle.getBundleContext());
        this.collectTaglibProviderBundles(bundles);
        this._allParticipatingBundles = bundles.toArray(new Bundle[bundles.size()]);
        this._jspBundleClassloader = new JspBundleClassloader(this._allParticipatingBundles);
        final HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("compilerClassName", "com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.JspCompiler");
        defaults.put("compilerSourceVM", "1.8");
        defaults.put("compilerTargetVM", "1.8");
        defaults.put("development", "false");
        defaults.put("httpMethods", "GET,POST,HEAD");
        defaults.put("keepgenerated", "false");
        defaults.put("logVerbosityLevel", "NONE");
        defaults.put("saveBytecode", "true");
        StringBundler sb = new StringBundler(4);
        sb.append(_WORK_DIR);
        sb.append(this._bundle.getSymbolicName());
        sb.append("-");
        sb.append((Object)this._bundle.getVersion());
        defaults.put(_INIT_PARAMETER_NAME_SCRATCH_DIR, sb.toString());
        defaults.put("tagpoolClassName", JspTagHandlerPool.class.getName());
        for (Map.Entry<Object, Object> entry : _initParams.entrySet()) {
            defaults.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        Enumeration names = servletConfig.getInitParameterNames();
        HashSet nameSet = new HashSet(Collections.list(names));
        nameSet.addAll(defaults.keySet());
        final Enumeration initParameterNames = Collections.enumeration(nameSet);
        this._jspServlet.init(new ServletConfig(){
            private final ServletContext _jspServletContext;
            {
                this._jspServletContext = (ServletContext)Proxy.newProxyInstance(JspServlet.this._jspBundleClassloader, _INTERFACES, (InvocationHandler)new JspServletContextInvocationHandler(servletContext, JspServlet.this._bundle));
            }

            public String getInitParameter(String name) {
                String value = servletConfig.getInitParameter(name);
                if (value == null) {
                    value = (String)defaults.get(name);
                }
                return value;
            }

            public Enumeration<String> getInitParameterNames() {
                return initParameterNames;
            }

            public ServletContext getServletContext() {
                return this._jspServletContext;
            }

            public String getServletName() {
                return servletConfig.getServletName();
            }
        });
        this._logVerbosityLevelDebug = Objects.equals(this._jspServlet.getInitParameter("logVerbosityLevel"), "DEBUG");
        this._bundleTracker = new BundleTracker(this._bundle.getBundleContext(), 4, (BundleTrackerCustomizer)new JspFragmentTrackerCustomizer());
        this._bundleTracker.open();
    }

    public void log(String msg) {
        this._jspServlet.log(msg);
    }

    public void log(String message, Throwable t) {
        this._jspServlet.log(message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this._jspBundleClassloader);
            if (this._logVerbosityLevelDebug) {
                String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
                if (path != null) {
                    String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                    if (pathInfo != null) {
                        path = path + pathInfo;
                    }
                } else {
                    path = request.getServletPath();
                    String pathInfo = request.getPathInfo();
                    if (pathInfo != null) {
                        path = path + pathInfo;
                    }
                }
                this._jspServlet.log(StringBundler.concat((String[])new String[]{"[JSP DEBUG] ", String.valueOf(this._bundle), " invoking ", path}));
            }
            this._jspServlet.service((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.service((HttpServletRequest)request, (HttpServletResponse)response);
    }

    public String toString() {
        return this._jspServlet.toString();
    }

    protected void collectTaglibProviderBundles(List<Bundle> bundles) {
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        for (BundleWire bundleWire : bundleWiring.getRequiredWires("osgi.extender")) {
            BundleRevision bundleRevision;
            Bundle bundle;
            BundleCapability bundleCapability = bundleWire.getCapability();
            Map attributes = bundleCapability.getAttributes();
            Object value = attributes.get("osgi.extender");
            if (!value.equals("jsp.taglib") || bundles.contains(bundle = (bundleRevision = bundleWire.getProvider()).getBundle())) continue;
            bundles.add(bundle);
        }
    }

    protected String[] getListenerClassNames(Class<?> clazz) {
        ArrayList<String> classNames = new ArrayList<String>();
        if (ServletContextListener.class.isAssignableFrom(clazz)) {
            classNames.add(ServletContextListener.class.getName());
        }
        if (ServletContextAttributeListener.class.isAssignableFrom(clazz)) {
            classNames.add(ServletContextAttributeListener.class.getName());
        }
        if (ServletRequestListener.class.isAssignableFrom(clazz)) {
            classNames.add(ServletRequestListener.class.getName());
        }
        if (ServletRequestAttributeListener.class.isAssignableFrom(clazz)) {
            classNames.add(ServletRequestAttributeListener.class.getName());
        }
        if (HttpSessionListener.class.isAssignableFrom(clazz)) {
            classNames.add(HttpSessionListener.class.getName());
        }
        if (HttpSessionAttributeListener.class.isAssignableFrom(clazz)) {
            classNames.add(HttpSessionAttributeListener.class.getName());
        }
        if (classNames.isEmpty()) {
            throw new IllegalArgumentException(clazz.getName() + " does not implement one of the supported servlet listener interfaces");
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static Map<Method, Method> _createContextAdapterMethods() {
        Method[] adapterMethods;
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        for (Method adapterMethod : adapterMethods = JspServletContextInvocationHandler.class.getDeclaredMethods()) {
            String name = adapterMethod.getName();
            Class<?>[] parameterTypes = adapterMethod.getParameterTypes();
            try {
                Method method = ServletContext.class.getMethod(name, parameterTypes);
                methods.put(method, adapterMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            Method equalsMethod = Object.class.getMethod("equals", Object.class);
            Method equalsHandlerMethod = JspServletContextInvocationHandler.class.getMethod("equals", Object.class);
            methods.put(equalsMethod, equalsHandlerMethod);
            Method hashCodeMethod = Object.class.getMethod("hashCode", null);
            Method hashCodeHandlerMethod = JspServletContextInvocationHandler.class.getMethod("hashCode", null);
            methods.put(hashCodeMethod, hashCodeHandlerMethod);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return methods;
    }

    private void _deleteOutdatedJspFiles(String dir, List<Path> paths) {
        FileSystem fileSystem = FileSystems.getDefault();
        Path dirPath = fileSystem.getPath(dir, new String[0]);
        if (Files.exists(dirPath, new LinkOption[0]) && !paths.isEmpty()) {
            try {
                Files.walkFileTree(dirPath, new DeleteFileVisitor(paths));
            }
            catch (IOException ioe) {
                this._logger.log(2, "Unable to delete outdated files: " + paths);
            }
        }
    }

    static {
        _initParams = PropsUtil.getProperties((String)"jsp.servlet.init.param.", (boolean)true);
        _jspBundle = FrameworkUtil.getBundle(JspServlet.class);
        _originalJspPattern = Pattern.compile("^(?<file>.*)(\\.(portal|original))(?<extension>\\.(jsp|jspf))$");
        _contextAdapterMethods = JspServlet._createContextAdapterMethods();
    }

    private class JspServletContextInvocationHandler
    implements InvocationHandler,
    JspServletContext {
        private final Bundle _bundle;
        private final ServletContext _servletContext;

        public JspServletContextInvocationHandler(ServletContext servletContext, Bundle bundle) {
            this._servletContext = servletContext;
            this._bundle = bundle;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServletContext)) {
                return false;
            }
            ServletContext servletContext = (ServletContext)obj;
            if (obj instanceof JspServletContext) {
                JspServletContext jspServletContext = (JspServletContext)obj;
                servletContext = jspServletContext.getWrappedServletContext();
            }
            return servletContext.equals(this._servletContext);
        }

        @Override
        public ServletContext getWrappedServletContext() {
            return this._servletContext;
        }

        public int hashCode() {
            return this._servletContext.hashCode();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getClassLoader")) {
                return JspServlet.this._jspBundleClassloader;
            }
            if (methodName.equals("getResource")) {
                return this._getResource((String)args[0]);
            }
            if (methodName.equals("getResourceAsStream")) {
                return this._getResourceAsStream((String)args[0]);
            }
            if (methodName.equals("getResourcePaths")) {
                return this._getResourcePaths((String)args[0]);
            }
            Method adapterMethod = (Method)_contextAdapterMethods.get(method);
            if (adapterMethod != null) {
                return adapterMethod.invoke((Object)this, args);
            }
            return method.invoke((Object)this._servletContext, args);
        }

        private URL _getExtension(String path) {
            Matcher matcher = _originalJspPattern.matcher(path);
            if (matcher.matches()) {
                path = matcher.group("file") + matcher.group("extension");
                return this._bundle.getEntry(JspServlet._DIR_NAME_RESOURCES + path);
            }
            Enumeration enumeration = this._bundle.findEntries(JspServlet._DIR_NAME_RESOURCES, path.substring(1), false);
            if (enumeration == null) {
                return null;
            }
            ArrayList urls = Collections.list(enumeration);
            return (URL)urls.get(urls.size() - 1);
        }

        private URL _getResource(String path) {
            try {
                URL url;
                if (path == null || path.equals("")) {
                    return null;
                }
                if (path.charAt(0) != '/') {
                    path = '/' + path;
                }
                if ((url = this._getExtension(path)) != null) {
                    return url;
                }
                url = this._servletContext.getResource(path);
                if (url != null) {
                    return url;
                }
                ClassLoader classLoader = this._servletContext.getClassLoader();
                url = classLoader.getResource(path);
                if (url != null) {
                    return url;
                }
                if (!path.startsWith("/META-INF/")) {
                    url = this._servletContext.getResource(JspServlet._DIR_NAME_RESOURCES.concat(path));
                }
                if (url != null) {
                    return url;
                }
                for (int i = 2; i < JspServlet.this._allParticipatingBundles.length; ++i) {
                    url = JspServlet.this._allParticipatingBundles[i].getEntry(path);
                    if (url == null) continue;
                    return url;
                }
                return _jspBundle.getResource(path);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        private InputStream _getResourceAsStream(String path) {
            URL url = this._getResource(path);
            if (url == null) {
                return null;
            }
            try {
                return url.openStream();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        private Set<String> _getResourcePaths(String path) {
            HashSet<String> paths = this._servletContext.getResourcePaths(path);
            Enumeration enumeration = _jspBundle.findEntries(path, null, false);
            if (enumeration != null) {
                if (paths == null && enumeration.hasMoreElements()) {
                    paths = new HashSet<String>();
                }
                while (enumeration.hasMoreElements()) {
                    URL url = (URL)enumeration.nextElement();
                    paths.add(url.getPath());
                }
            }
            return paths;
        }
    }

    private class JspFragmentTrackerCustomizer
    implements BundleTrackerCustomizer<List<Path>> {
        private JspFragmentTrackerCustomizer() {
        }

        public List<Path> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            ArrayList<Path> paths = new ArrayList<Path>();
            Dictionary headers = bundle.getHeaders("");
            String fragmentHost = (String)headers.get("Fragment-Host");
            if (fragmentHost == null) {
                return null;
            }
            String[] fragmentHostParts = StringUtil.split((String)fragmentHost, (char)';');
            fragmentHost = fragmentHostParts[0];
            String symbolicName = JspServlet.this._bundle.getSymbolicName();
            if (!symbolicName.equals(fragmentHost)) {
                return null;
            }
            Enumeration enumeration = bundle.findEntries(JspServlet._DIR_NAME_RESOURCES, "*.jsp", true);
            if (enumeration == null) {
                return paths;
            }
            String scratchDirName = JspServlet.this._jspServlet.getInitParameter(JspServlet._INIT_PARAMETER_NAME_SCRATCH_DIR);
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                String pathString = url.getPath();
                pathString = pathString.startsWith(JspServlet._DIR_NAME_RESOURCES) ? pathString.substring(JspServlet._DIR_NAME_RESOURCES.length() + 1, pathString.length() - 4) : pathString.substring(1, pathString.length() - 4);
                pathString = StringUtil.replace((String)pathString, (char)'_', (String)"_005f");
                paths.add(Paths.get(scratchDirName, "/org/apache/jsp/" + pathString + "_jsp.class"));
            }
            JspServlet.this._deleteOutdatedJspFiles(scratchDirName, paths);
            return paths;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<Path> paths) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<Path> paths) {
            String scratchDirName = JspServlet.this._jspServlet.getInitParameter(JspServlet._INIT_PARAMETER_NAME_SCRATCH_DIR);
            JspServlet.this._deleteOutdatedJspFiles(scratchDirName, paths);
        }
    }

    private class DeleteFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Path> _paths;

        public DeleteFileVisitor(List<Path> paths) {
            this._paths = paths;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this._paths.contains(file.toAbsolutePath())) {
                Files.delete(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

