/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.BaseJavaFileObject;
import com.liferay.portal.osgi.web.servlet.jsp.compiler.internal.JavaFileObjectResolver;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class BundleJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    public static final String OPT_VERBOSE = "-verbose";
    private static final Log _log = LogFactoryUtil.getLog(BundleJavaFileManager.class);
    private static final Set<JavaFileObject.Kind> _kinds = EnumSet.of(JavaFileObject.Kind.CLASS);
    private static SoftReference<Field> _nameFieldReference;
    private final ClassLoader _classLoader;
    private final List<JavaFileObjectResolver> _javaFileObjectResolvers;

    public BundleJavaFileManager(ClassLoader classLoader, JavaFileManager javaFileManager, List<JavaFileObjectResolver> javaFileObjectResolvers) {
        super(javaFileManager);
        this._classLoader = classLoader;
        this._javaFileObjectResolvers = javaFileObjectResolvers;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (location != StandardLocation.CLASS_PATH) {
            return this.fileManager.getClassLoader(location);
        }
        return this._classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.CLASS_PATH && file instanceof BaseJavaFileObject) {
            BaseJavaFileObject baseJavaFileObject = (BaseJavaFileObject)file;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Inferring binary name from " + baseJavaFileObject));
            }
            return baseJavaFileObject.getClassName();
        }
        Field nameField = BundleJavaFileManager._getZipFileIndexFileObjectNameField();
        if (nameField != null && file.getClass() == nameField.getDeclaringClass()) {
            try {
                String name = (String)nameField.get(file);
                return name.substring(0, name.lastIndexOf(46));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this.fileManager.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (!kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            return Collections.emptyList();
        }
        if (location == StandardLocation.CLASS_PATH && _log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(9);
            sb.append("List for {kinds=");
            sb.append(_kinds);
            sb.append(", location=");
            sb.append((Object)location);
            sb.append(", packageName=");
            sb.append(packageName);
            sb.append(", recurse=");
            sb.append(recurse);
            sb.append("}");
            _log.info((Object)sb.toString());
        }
        String packagePath = packageName.replace('.', '/');
        if (!packageName.startsWith("java.") && location == StandardLocation.CLASS_PATH) {
            for (JavaFileObjectResolver javaFileObjectResolver : this._javaFileObjectResolvers) {
                Collection<JavaFileObject> javaFileObjects = javaFileObjectResolver.resolveClasses(recurse, packagePath);
                if (javaFileObjects.isEmpty()) continue;
                return javaFileObjects;
            }
        }
        return this.fileManager.list(location, packagePath, _kinds, recurse);
    }

    private static Field _doGetZipFileIndexFileObjectNameField() {
        if ((JavaDetector.isOpenJDK() || JavaDetector.isOracle()) && GetterUtil.getBoolean((String)SystemProperties.get((String)"portal.servlet.jsp.compiler.sun.javac.hack.enabled"), (boolean)true)) {
            try {
                ClassLoader systemToolClassLoader = ToolProvider.getSystemToolClassLoader();
                Class<?> zipFileIndexFileObjectClass = systemToolClassLoader.loadClass("com.sun.tools.javac.file.ZipFileIndexArchive$ZipFileIndexFileObject");
                Field nameField = zipFileIndexFileObjectClass.getDeclaredField("name");
                nameField.setAccessible(true);
                return nameField;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Field _getZipFileIndexFileObjectNameField() {
        if (_nameFieldReference == null) {
            return null;
        }
        Field nameField = _nameFieldReference.get();
        if (nameField != null) {
            return nameField;
        }
        nameField = BundleJavaFileManager._doGetZipFileIndexFileObjectNameField();
        _nameFieldReference = new SoftReference<Field>(nameField);
        return nameField;
    }

    static {
        Field nameField = BundleJavaFileManager._doGetZipFileIndexFileObjectNameField();
        if (nameField != null) {
            _nameFieldReference = new SoftReference<Field>(nameField);
        }
    }
}

