/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.context.helper.internal;

import com.liferay.portal.kernel.servlet.PortletServlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.web.servlet.JSPServletFactory;
import com.liferay.portal.osgi.web.servlet.context.helper.ServletContextHelperRegistration;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebXMLDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.CustomServletContextHelper;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.JspServletWrapper;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.definition.WebXMLDefinitionLoader;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.context.ServletContextHelper;

public class ServletContextHelperRegistrationImpl
implements ServletContextHelperRegistration {
    private static final String _JSP_SERVLET_INIT_PARAM_PREFIX = "jsp.servlet.init.param.";
    private static final String _SERVLET_INIT_PARAM_PREFIX = "servlet.init.";
    private final Bundle _bundle;
    private final BundleContext _bundleContext;
    private final CustomServletContextHelper _customServletContextHelper;
    private final ServiceRegistration<?> _defaultServletServiceRegistration;
    private final JSPServletFactory _jspServletFactory;
    private final ServiceRegistration<Servlet> _jspServletServiceRegistration;
    private final ServiceRegistration<Servlet> _portletServletServiceRegistration;
    private final Map<String, Object> _properties;
    private final ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
    private final ServiceRegistration<ServletContextListener> _servletContextListenerServiceRegistration;
    private final String _servletContextName;
    private ServiceRegistration<ServletContext> _servletContextRegistration;
    private final boolean _wabShapedBundle;
    private final WebXMLDefinition _webXMLDefinition;

    public ServletContextHelperRegistrationImpl(Bundle bundle, JSPServletFactory jspServletFactory, SAXParserFactory saxParserFactory, Map<String, Object> properties) {
        this._bundle = bundle;
        this._jspServletFactory = jspServletFactory;
        this._properties = properties;
        String contextPath = this.getContextPath();
        this._servletContextName = this.getServletContextName(contextPath);
        URL url = this._bundle.getEntry("WEB-INF/");
        if (url != null) {
            this._wabShapedBundle = true;
            WebXMLDefinitionLoader webXMLDefinitionLoader = new WebXMLDefinitionLoader(this._bundle, this._jspServletFactory, saxParserFactory);
            WebXMLDefinition webXMLDefinition = null;
            try {
                webXMLDefinition = webXMLDefinitionLoader.loadWebXML();
            }
            catch (Exception e) {
                webXMLDefinition = new WebXMLDefinition();
                webXMLDefinition.setException(e);
            }
            this._webXMLDefinition = webXMLDefinition;
        } else {
            this._wabShapedBundle = false;
            this._webXMLDefinition = new WebXMLDefinition();
        }
        this._bundleContext = this._bundle.getBundleContext();
        this._customServletContextHelper = new CustomServletContextHelper(this._bundle, this._webXMLDefinition.getWebResourceCollectionDefinitions());
        this._servletContextHelperServiceRegistration = this.createServletContextHelper(contextPath);
        this._servletContextListenerServiceRegistration = this.createServletContextListener();
        this.registerServletContext();
        this._defaultServletServiceRegistration = this.createDefaultServlet();
        this._jspServletServiceRegistration = this.createJspServlet();
        this._portletServletServiceRegistration = this.createPortletServlet();
    }

    public void close() {
        try {
            this._servletContextRegistration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this._servletContextHelperServiceRegistration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this._servletContextListenerServiceRegistration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this._defaultServletServiceRegistration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this._jspServletServiceRegistration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this._portletServletServiceRegistration != null) {
            try {
                this._portletServletServiceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public ServletContext getServletContext() {
        return this._customServletContextHelper.getServletContext();
    }

    public WebXMLDefinition getWebXMLDefinition() {
        return this._webXMLDefinition;
    }

    public boolean isWabShapedBundle() {
        return this._wabShapedBundle;
    }

    public void setProperties(Map<String, String> contextParameters) {
        if (contextParameters.isEmpty()) {
            return;
        }
        ServiceReference serviceReference = this._servletContextHelperServiceRegistration.getReference();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String key : serviceReference.getPropertyKeys()) {
            ((Dictionary)properties).put(key, serviceReference.getProperty(key));
        }
        for (Map.Entry entry : contextParameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ((Dictionary)properties).put("context.init." + key, value);
        }
        this._servletContextHelperServiceRegistration.setProperties(properties);
    }

    protected ServiceRegistration<?> createDefaultServlet() {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.select", this._servletContextName);
        String prefix = "/META-INF/resources";
        if (this._wabShapedBundle) {
            prefix = "/";
        }
        properties.put("osgi.http.whiteboard.resource.prefix", prefix);
        properties.put("osgi.http.whiteboard.resource.pattern", "/*");
        return this._bundleContext.registerService(Object.class, new Object(), (Dictionary)properties);
    }

    protected ServiceRegistration<Servlet> createJspServlet() {
        HashMapDictionary properties = new HashMapDictionary();
        for (Map.Entry<String, Object> entry : this._properties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(_JSP_SERVLET_INIT_PARAM_PREFIX)) continue;
            String name = _SERVLET_INIT_PARAM_PREFIX + key.substring(_JSP_SERVLET_INIT_PARAM_PREFIX.length());
            properties.put(name, entry.getValue());
        }
        properties.put("osgi.http.whiteboard.context.select", this._servletContextName);
        properties.put("osgi.http.whiteboard.servlet.name", JspServletWrapper.class.getName());
        properties.put("osgi.http.whiteboard.servlet.pattern", new String[]{"*.jsp", "*.jspx"});
        return this._bundleContext.registerService(Servlet.class, (Object)this._jspServletFactory.createJSPServlet(), (Dictionary)properties);
    }

    protected ServiceRegistration<Servlet> createPortletServlet() {
        if (this._wabShapedBundle) {
            return null;
        }
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.http.whiteboard.context.select", this._servletContextName);
        properties.put("osgi.http.whiteboard.servlet.name", PortletServlet.class.getName());
        properties.put("osgi.http.whiteboard.servlet.pattern", "/portlet-servlet/*");
        return this._bundleContext.registerService(Servlet.class, (Object)new PortletServlet(){}, (Dictionary)properties);
    }

    protected ServiceRegistration<ServletContextHelper> createServletContextHelper(String contextPath) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.http.whiteboard.context.name", this._servletContextName);
        ((Dictionary)properties).put("osgi.http.whiteboard.context.path", contextPath);
        Map contextParameters = this._webXMLDefinition.getContextParameters();
        ((Dictionary)properties).put("rtl.required", String.valueOf(this.isRTLRequired(contextParameters)));
        for (Map.Entry entry : contextParameters.entrySet()) {
            String key = "context.init." + (String)entry.getKey();
            ((Dictionary)properties).put(key, (String)entry.getValue());
        }
        return this._bundleContext.registerService(ServletContextHelper.class, (Object)this._customServletContextHelper, properties);
    }

    protected ServiceRegistration<ServletContextListener> createServletContextListener() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", this._servletContextName);
        ((Dictionary)properties).put("osgi.http.whiteboard.listener", Boolean.TRUE.toString());
        return this._bundleContext.registerService(ServletContextListener.class, (Object)this._customServletContextHelper, properties);
    }

    protected String getContextPath() {
        Dictionary headers = this._bundle.getHeaders("");
        String contextPath = (String)headers.get("Web-ContextPath");
        if (Validator.isNotNull((String)contextPath)) {
            return contextPath;
        }
        return '/' + this._bundle.getSymbolicName();
    }

    protected String getServletContextName(String contextPath) {
        Dictionary headers = this._bundle.getHeaders("");
        String header = (String)headers.get("Web-ContextName");
        if (Validator.isNotNull((String)header)) {
            return header;
        }
        return contextPath.substring(1);
    }

    protected boolean isRTLRequired(Map<String, String> contextParameters) {
        String rtlRequired = contextParameters.get("rtl.required");
        if (Validator.isNotNull((String)rtlRequired)) {
            return GetterUtil.getBoolean((String)rtlRequired);
        }
        Dictionary headers = this._bundle.getHeaders("");
        rtlRequired = (String)headers.get("Liferay-RTL-Support-Required");
        if (Validator.isNotNull((String)rtlRequired)) {
            return GetterUtil.getBoolean((String)rtlRequired);
        }
        return true;
    }

    protected void registerServletContext() {
        ServletContext servletContext = this._customServletContextHelper.getServletContext();
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("osgi.web.contextname", servletContext.getServletContextName());
        properties.put("osgi.web.contextpath", servletContext.getContextPath());
        properties.put("osgi.web.symbolicname", this._bundle.getSymbolicName());
        properties.put("osgi.web.version", this._bundle.getVersion());
        this._servletContextRegistration = this._bundleContext.registerService(ServletContext.class, (Object)servletContext, (Dictionary)properties);
    }
}

