/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.context.helper.internal;

import com.liferay.osgi.util.BundleUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebResourceCollectionDefinition;
import com.liferay.portal.servlet.delegate.ServletContextDelegate;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;

public class CustomServletContextHelper
extends ServletContextHelper
implements ServletContextListener {
    private static final Log _log = LogFactoryUtil.getLog(CustomServletContextHelper.class);
    private final Bundle _bundle;
    private ServletContext _servletContext;
    private final String _string;
    private final List<WebResourceCollectionDefinition> _webResourceCollectionDefinitions;

    public CustomServletContextHelper(Bundle bundle, List<WebResourceCollectionDefinition> webResourceCollectionDefinitions) {
        super(bundle);
        this._bundle = bundle;
        this._webResourceCollectionDefinitions = webResourceCollectionDefinitions;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        this._string = clazz.getSimpleName() + '[' + bundle + ']';
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContextClassLoaderPool.unregister((String)this._servletContext.getServletContextName());
        this._servletContext = null;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this._servletContext = ServletContextDelegate.create((ServletContext)servletContextEvent.getServletContext());
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        ServletContextClassLoaderPool.register((String)this._servletContext.getServletContextName(), (ClassLoader)bundleWiring.getClassLoader());
    }

    public String getRealPath(String path) {
        return null;
    }

    public URL getResource(String name) {
        if (name == null || name.contains("*")) {
            return null;
        }
        if (name.isEmpty()) {
            name = "/";
        } else if (name.charAt(0) != '/') {
            name = "/".concat(name);
        }
        URL url = BundleUtil.getResourceInBundleOrFragments((Bundle)this._bundle, (String)name);
        if (url == null) {
            url = BundleUtil.getResourceInBundleOrFragments((Bundle)this._bundle, (String)("/META-INF/resources" + name));
        }
        if (url == null) {
            try {
                Enumeration enumeration = this._bundle.getResources("/META-INF/resources" + name);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    url = (URL)enumeration.nextElement();
                }
            }
            catch (IOException ioe) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to get resource name ", name, " on bundle ", this._bundle}), (Throwable)ioe);
            }
        }
        return url;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public boolean handleSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest.getDispatcherType() != DispatcherType.ASYNC && httpServletRequest.getDispatcherType() != DispatcherType.REQUEST) {
            return true;
        }
        String path = httpServletRequest.getPathInfo();
        if (path == null) {
            return true;
        }
        if (path.indexOf(47) != 0) {
            path = '/' + path;
        }
        if (path.startsWith("/META-INF/") || path.startsWith("/OSGI-INF/") || path.startsWith("/OSGI-OPT/") || path.startsWith("/WEB-INF/")) {
            return this.sendErrorForbidden(httpServletRequest, httpServletResponse, path);
        }
        if (ListUtil.isEmpty(this._webResourceCollectionDefinitions)) {
            return true;
        }
        for (WebResourceCollectionDefinition webResourceCollectionDefinition : this._webResourceCollectionDefinitions) {
            boolean forbidden = false;
            for (String urlPattern : webResourceCollectionDefinition.getUrlPatterns()) {
                if (urlPattern.startsWith("*.")) {
                    String patternExtension = urlPattern.substring(2);
                    if (Validator.isNotNull((String)patternExtension) && Objects.equals("*", patternExtension)) {
                        forbidden = true;
                        break;
                    }
                    int index = path.lastIndexOf(".");
                    String pathExtension = path.substring(index + 1);
                    if (!Objects.equals(patternExtension, pathExtension)) continue;
                    forbidden = true;
                    break;
                }
                if (urlPattern.endsWith("/*")) {
                    if (urlPattern.equals("/*")) {
                        forbidden = true;
                        break;
                    }
                    String subpath = path;
                    String urlPatternPath = urlPattern.substring(0, urlPattern.indexOf("/*") + 1);
                    int index = subpath.lastIndexOf("/");
                    if (index > 0) {
                        subpath = subpath.substring(0, index + 1);
                    }
                    if (!Objects.equals(urlPatternPath, subpath)) continue;
                    forbidden = true;
                    break;
                }
                if (!Objects.equals(urlPattern, path)) continue;
                forbidden = true;
                break;
            }
            if (forbidden) {
                List httpMethodExceptions;
                List httpMethods = webResourceCollectionDefinition.getHttpMethods();
                if (ListUtil.isNotEmpty((List)httpMethods) && !httpMethods.contains(httpServletRequest.getMethod())) {
                    forbidden = false;
                }
                if (ListUtil.isNotEmpty((List)(httpMethodExceptions = webResourceCollectionDefinition.getHttpMethodExceptions())) && httpMethodExceptions.contains(httpServletRequest.getMethod())) {
                    forbidden = false;
                }
            }
            if (!forbidden) continue;
            return this.sendErrorForbidden(httpServletRequest, httpServletResponse, path);
        }
        return true;
    }

    public String toString() {
        return this._string;
    }

    protected boolean sendErrorForbidden(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path) {
        try {
            ServletContext servletContext = httpServletRequest.getServletContext();
            servletContext.log(StringBundler.concat((String[])new String[]{"[WAB ERROR] Attempt to load illegal path ", path, " in ", this.toString()}));
            httpServletResponse.sendError(403, path);
        }
        catch (IOException ioe) {
            httpServletResponse.setStatus(403);
        }
        return false;
    }
}

