/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.context.helper.internal.order;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebXMLDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.order.Order;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;

public class OrderCircularDependencyException
extends Exception {
    public OrderCircularDependencyException(Order.Path path, List<WebXMLDefinition> webXMLDefinitions) {
        super(OrderCircularDependencyException._getMessage(path, webXMLDefinitions));
    }

    private static String _getMessage(Order.Path path, List<WebXMLDefinition> webXMLDefinitions) {
        StringBundler sb = new StringBundler();
        sb.append("Circular dependencies detected when traversing ");
        sb.append(path.name());
        sb.append(" declarations:");
        for (WebXMLDefinition webXMLDefinition : webXMLDefinitions) {
            Order order = webXMLDefinition.getOrder();
            EnumMap routes = order.getRoutes();
            String[] names = (String[])routes.get(path);
            if (names.length == 0) continue;
            sb.append("\n");
            sb.append(webXMLDefinition.getFragmentName());
            sb.append(" ");
            sb.append(path.name());
            sb.append(": ");
            sb.append(Arrays.asList(names));
        }
        return sb.toString();
    }
}

