/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.context.helper.internal;

import com.liferay.osgi.util.BundleUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebResourceCollectionDefinition;
import com.liferay.portal.servlet.delegate.ServletContextDelegate;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.context.ServletContextHelper;

public class CustomServletContextHelper
extends ServletContextHelper
implements ServletContextListener {
    private final Bundle _bundle;
    private final Logger _logger;
    private ServletContext _servletContext;
    private final String _string;
    private final List<WebResourceCollectionDefinition> _webResourceCollectionDefinitions;

    public CustomServletContextHelper(Bundle bundle, Logger logger, List<WebResourceCollectionDefinition> webResourceCollectionDefinitions) {
        super(bundle);
        this._bundle = bundle;
        this._logger = logger;
        this._webResourceCollectionDefinitions = webResourceCollectionDefinitions;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        this._string = clazz.getSimpleName() + '[' + bundle + ']';
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContextClassLoaderPool.unregister((String)this._servletContext.getServletContextName());
        this._servletContext = null;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this._servletContext = ServletContextDelegate.create((ServletContext)servletContextEvent.getServletContext());
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        ServletContextClassLoaderPool.register((String)this._servletContext.getServletContextName(), (ClassLoader)bundleWiring.getClassLoader());
    }

    public String getRealPath(String path) {
        return null;
    }

    public URL getResource(String name) {
        if (name == null || name.contains("*")) {
            return null;
        }
        if (name.isEmpty()) {
            name = "/";
        } else if (name.charAt(0) != '/') {
            name = "/".concat(name);
        }
        URL url = BundleUtil.getResourceInBundleOrFragments((Bundle)this._bundle, (String)name);
        if (url == null) {
            url = BundleUtil.getResourceInBundleOrFragments((Bundle)this._bundle, (String)("/META-INF/resources" + name));
        }
        if (url == null) {
            try {
                Enumeration enumeration = this._bundle.getResources("/META-INF/resources" + name);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    url = (URL)enumeration.nextElement();
                }
            }
            catch (IOException ioe) {
                this._logger.log(1, StringBundler.concat((Object[])new Object[]{"Unable to get resource name ", name, " on bundle ", this._bundle}), (Throwable)ioe);
            }
        }
        return url;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) {
        if (request.getDispatcherType() != DispatcherType.ASYNC && request.getDispatcherType() != DispatcherType.REQUEST) {
            return true;
        }
        String path = request.getPathInfo();
        if (path == null) {
            return true;
        }
        if (path.indexOf(47) != 0) {
            path = '/' + path;
        }
        if (path.startsWith("/META-INF/") || path.startsWith("/OSGI-INF/") || path.startsWith("/OSGI-OPT/") || path.startsWith("/WEB-INF/")) {
            return this.sendErrorForbidden(request, response, path);
        }
        if (ListUtil.isEmpty(this._webResourceCollectionDefinitions)) {
            return true;
        }
        for (WebResourceCollectionDefinition webResourceCollectionDefinition : this._webResourceCollectionDefinitions) {
            boolean forbidden = false;
            for (String urlPattern : webResourceCollectionDefinition.getUrlPatterns()) {
                if (urlPattern.startsWith("*.")) {
                    String patternExtension = urlPattern.substring(2);
                    if (Validator.isNotNull((String)patternExtension) && Objects.equals("*", patternExtension)) {
                        forbidden = true;
                        break;
                    }
                    int index = path.lastIndexOf(".");
                    String pathExtension = path.substring(index + 1);
                    if (!Objects.equals(patternExtension, pathExtension)) continue;
                    forbidden = true;
                    break;
                }
                if (urlPattern.endsWith("/*")) {
                    if (urlPattern.equals("/*")) {
                        forbidden = true;
                        break;
                    }
                    String subpath = path;
                    String urlPatternPath = urlPattern.substring(0, urlPattern.indexOf("/*") + 1);
                    int index = subpath.lastIndexOf("/");
                    if (index > 0) {
                        subpath = subpath.substring(0, index + 1);
                    }
                    if (!Objects.equals(urlPatternPath, subpath)) continue;
                    forbidden = true;
                    break;
                }
                if (!Objects.equals(urlPattern, path)) continue;
                forbidden = true;
                break;
            }
            if (forbidden) {
                List httpMethodExceptions;
                List httpMethods = webResourceCollectionDefinition.getHttpMethods();
                if (ListUtil.isNotEmpty((List)httpMethods) && !httpMethods.contains(request.getMethod())) {
                    forbidden = false;
                }
                if (ListUtil.isNotEmpty((List)(httpMethodExceptions = webResourceCollectionDefinition.getHttpMethodExceptions())) && httpMethodExceptions.contains(request.getMethod())) {
                    forbidden = false;
                }
            }
            if (!forbidden) continue;
            return this.sendErrorForbidden(request, response, path);
        }
        return true;
    }

    public String toString() {
        return this._string;
    }

    protected boolean sendErrorForbidden(HttpServletRequest request, HttpServletResponse response, String path) {
        try {
            ServletContext servletContext = request.getServletContext();
            servletContext.log(StringBundler.concat((String[])new String[]{"[WAB ERROR] Attempt to load illegal path ", path, " in ", this.toString()}));
            response.sendError(403, path);
        }
        catch (IOException ioe) {
            response.setStatus(403);
        }
        return false;
    }
}

