/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.portlet.tracker.internal;

import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.SpriteImage;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;

public class BundlePortletAppDelegate {
    private String _defaultNamespace;
    private final Set<EventDefinition> _eventDefinitions = new HashSet<EventDefinition>();
    private final PortletApp _portletApp;
    private final Set<PortletURLListener> _portletURLListeners = new LinkedHashSet<PortletURLListener>();
    private final Map<String, PortletURLListener> _portletURLListenersMap = new HashMap<String, PortletURLListener>();
    private final ServletContext _servletContext;
    private int _specMajorVersion = 2;
    private int _specMinorVersion;
    private final Map<String, SpriteImage> _spriteImagesMap = new HashMap<String, SpriteImage>();
    private boolean _warFile = true;

    public BundlePortletAppDelegate(Portlet portalPortletModel, ServletContext servletContext) {
        this._servletContext = servletContext;
        this._portletApp = portalPortletModel.getPortletApp();
    }

    public void addEventDefinition(EventDefinition eventDefinition) {
        this._eventDefinitions.add(eventDefinition);
    }

    public void addPortletURLListener(PortletURLListener portletURLListener) {
        this._portletURLListeners.add(portletURLListener);
        this._portletURLListenersMap.put(portletURLListener.getListenerClass(), portletURLListener);
    }

    public String getContextPath() {
        ServletContext servletContext = this.getServletContext();
        return servletContext.getContextPath();
    }

    public String getDefaultNamespace() {
        if (this._defaultNamespace == null) {
            return this._portletApp.getDefaultNamespace();
        }
        return this._defaultNamespace;
    }

    public Set<EventDefinition> getEventDefinitions() {
        return this._eventDefinitions;
    }

    public PortletURLListener getPortletURLListener(String listenerClass) {
        return this._portletURLListenersMap.get(listenerClass);
    }

    public Set<PortletURLListener> getPortletURLListeners() {
        return this._portletURLListeners;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public String getServletContextName() {
        ServletContext servletContext = this.getServletContext();
        return servletContext.getServletContextName();
    }

    public int getSpecMajorVersion() {
        return this._specMajorVersion;
    }

    public int getSpecMinorVersion() {
        return this._specMinorVersion;
    }

    public SpriteImage getSpriteImage(String fileName) {
        return this._spriteImagesMap.get(fileName);
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this._defaultNamespace = Validator.isNull((String)defaultNamespace) ? null : defaultNamespace;
    }

    public void setServletContext(ServletContext servletContext) {
        throw new UnsupportedOperationException();
    }

    public void setSpecMajorVersion(int specMajorVersion) {
        this._specMajorVersion = specMajorVersion;
    }

    public void setSpecMinorVersion(int specMinorVersion) {
        this._specMinorVersion = specMinorVersion;
    }

    public void setSpriteImages(String spriteFileName, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int[] values = StringUtil.split((String)value, (int)0);
            int offset = values[0];
            int height = values[1];
            int width = values[2];
            SpriteImage spriteImage = new SpriteImage(spriteFileName, key, offset, height, width);
            this._spriteImagesMap.put(key, spriteImage);
        }
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }
}

