/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.portlet.tracker.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.osgi.util.StringPlus;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.application.type.ApplicationType;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.PortletInfo;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.portlet.PortletDependencyFactory;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactory;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.model.impl.EventDefinitionImpl;
import com.liferay.portal.model.impl.PortletURLListenerImpl;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import com.liferay.portal.osgi.web.portlet.tracker.internal.BundlePortletApp;
import com.liferay.portal.osgi.web.portlet.tracker.internal.PortletPropertyValidator;
import com.liferay.portal.osgi.web.servlet.context.helper.ServletContextHelperFactory;
import com.liferay.portal.osgi.web.servlet.context.helper.ServletContextHelperRegistration;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.Portlet;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={PortletTracker.class})
public class PortletTracker
implements ServiceTrackerCustomizer<Portlet, com.liferay.portal.kernel.model.Portlet> {
    private static final String _NAMESPACE = "com.liferay.portlet.";
    private static final Log _log = LogFactoryUtil.getLog(PortletTracker.class);
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    private String _httpServiceEndpoint = "";
    @Reference(target="(module.service.lifecycle=portlets.initialized)", unbind="-")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private Portal _portal;
    @Reference
    private PortletDependencyFactory _portletDependencyFactory;
    @Reference
    private PortletInstanceFactory _portletInstanceFactory;
    @Reference
    private PortletLocalService _portletLocalService;
    private final PortletPropertyValidator _portletPropertyValidator = new PortletPropertyValidator();
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private SAXReader _saxReader;
    private final ConcurrentMap<Long, ServiceRegistrations> _serviceRegistrations = new ConcurrentHashMap<Long, ServiceRegistrations>();
    private ServiceTracker<Portlet, com.liferay.portal.kernel.model.Portlet> _serviceTracker;
    @Reference
    private ServletContextHelperFactory _servletContextHelperFactory;
    private ServiceReference<ServletContextHelperRegistration> _servletContextHelperRegistrationServiceReference;

    public com.liferay.portal.kernel.model.Portlet addingService(ServiceReference<Portlet> serviceReference) {
        Portlet portlet = (Portlet)this._bundleContext.getService(serviceReference);
        if (portlet == null) {
            return null;
        }
        String portletName = (String)serviceReference.getProperty("javax.portlet.name");
        if (Validator.isNull((String)portletName)) {
            Class<?> clazz = portlet.getClass();
            portletName = clazz.getName();
        }
        String portletId = StringUtil.replace((String)portletName, (char[])new char[]{'.', '$'}, (char[])new char[]{'_', '_'});
        if ((portletId = this._portal.getJsSafePortletId(portletId)).length() > PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Portlet ID ", portletId, " has more than ", PortletIdCodec.PORTLET_INSTANCE_KEY_MAX_LENGTH, " characters"}));
            this._bundleContext.ungetService(serviceReference);
            return null;
        }
        com.liferay.portal.kernel.model.Portlet portletModel = this._portletLocalService.getPortletById(portletId);
        if (portletModel != null) {
            _log.error((Object)("Portlet id " + portletId + " is already in use"));
            this._bundleContext.ungetService(serviceReference);
            return null;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding " + serviceReference));
        }
        if ((portletModel = this.addingPortlet(serviceReference, portlet, portletName, portletId)) == null) {
            this._bundleContext.ungetService(serviceReference);
        }
        return portletModel;
    }

    public void modifiedService(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        this.removedService(serviceReference, portletModel);
        com.liferay.portal.kernel.model.Portlet newPortletModel = this.addingService(serviceReference);
        if (newPortletModel == null) {
            return;
        }
        BeanPropertiesUtil.copyProperties((Object)newPortletModel, (Object)portletModel);
    }

    public void removedService(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        portletModel.unsetReady();
        ServiceRegistrations serviceRegistrations = (ServiceRegistrations)this._serviceRegistrations.get((Long)serviceReference.getProperty("service.bundleid"));
        if (serviceRegistrations == null) {
            return;
        }
        BundlePortletApp bundlePortletApp = serviceRegistrations.getBundlePortletApp();
        bundlePortletApp.removePortlet(portletModel);
        try {
            this._bundleContext.ungetService(serviceReference);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this._portletInstanceFactory.destroy(portletModel);
        List companies = this._companyLocalService.getCompanies();
        for (Company company : companies) {
            PortletCategory portletCategory = (PortletCategory)WebAppPool.get((Long)company.getCompanyId(), (String)"PORTLET_CATEGORY");
            portletCategory.separate(portletModel.getRootPortletId());
        }
        serviceRegistrations.removeServiceReference(serviceReference);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext) {
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
        this._bundleContext = bundleContext;
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, Portlet.class, (ServiceTrackerCustomizer)this);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Activated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected com.liferay.portal.kernel.model.Portlet addingPortlet(ServiceReference<Portlet> serviceReference, Portlet portlet, String portletName, String portletId) {
        this._warnPorletProperties(portletName, serviceReference);
        Bundle bundle = serviceReference.getBundle();
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader bundleClassLoader = bundleWiring.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(bundleWiring.getClassLoader());
        ServiceRegistrations serviceRegistrations = this.getServiceRegistrations(bundle);
        try {
            BundlePortletApp bundlePortletApp = this.createBundlePortletApp(bundle, bundleClassLoader, serviceRegistrations);
            bundlePortletApp.setDefaultNamespace((String)serviceReference.getProperty("javax.portlet.default-namespace"));
            String jxPortletVersion = (String)serviceReference.getProperty("javax.portlet.version");
            if (jxPortletVersion == null) {
                bundlePortletApp.setSpecMajorVersion(2);
                bundlePortletApp.setSpecMinorVersion(0);
            } else {
                String[] jxPortletVersionParts = StringUtil.split((String)jxPortletVersion, (char)'.');
                if (jxPortletVersionParts.length > 0) {
                    bundlePortletApp.setSpecMajorVersion(GetterUtil.getInteger((String)jxPortletVersionParts[0], (int)2));
                    if (jxPortletVersionParts.length > 1) {
                        bundlePortletApp.setSpecMinorVersion(GetterUtil.getInteger((String)jxPortletVersionParts[1]));
                    }
                }
            }
            com.liferay.portal.kernel.model.Portlet portletModel = this.buildPortletModel(bundlePortletApp, portletId);
            portletModel.setPortletName(portletName);
            String displayName = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.display-name"), (String)portletName);
            portletModel.setDisplayName(displayName);
            Class<?> portletClazz = portlet.getClass();
            portletModel.setPortletClass(portletClazz.getName());
            this.collectJxPortletFeatures(serviceReference, portletModel);
            this.collectLiferayFeatures(serviceReference, portletModel);
            PortletContextBag portletContextBag = new PortletContextBag(bundlePortletApp.getServletContextName());
            PortletContextBagPool.put((String)bundlePortletApp.getServletContextName(), (PortletContextBag)portletContextBag);
            PortletBagFactory portletBagFactory = new PortletBagFactory();
            portletBagFactory.setClassLoader(bundleClassLoader);
            portletBagFactory.setServletContext(bundlePortletApp.getServletContext());
            portletBagFactory.setWARFile(true);
            portletBagFactory.create(portletModel, portlet, true);
            List companies = this._companyLocalService.getCompanies();
            this.deployPortlet(serviceReference, portletModel, companies);
            portletModel.setReady(true);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Added " + serviceReference));
            }
            serviceRegistrations.addServiceReference(serviceReference);
            com.liferay.portal.kernel.model.Portlet portlet2 = portletModel;
            return portlet2;
        }
        catch (Exception e) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Portlet ", portletId, " from ", bundle, " failed to initialize"}), (Throwable)e);
            com.liferay.portal.kernel.model.Portlet portlet3 = null;
            return portlet3;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected com.liferay.portal.kernel.model.Portlet buildPortletModel(BundlePortletApp bundlePortletApp, String portletId) {
        com.liferay.portal.kernel.model.Portlet portletModel = this._portletLocalService.createPortlet(0L);
        portletModel.setPortletId(portletId);
        portletModel.setCompanyId(0L);
        portletModel.setPluginPackage((PluginPackage)bundlePortletApp.getPluginPackage());
        portletModel.setPortletApp((PortletApp)bundlePortletApp);
        portletModel.setRoleMappers(bundlePortletApp.getRoleMappers());
        portletModel.setStrutsPath(portletId);
        return portletModel;
    }

    protected void collectApplicationTypes(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<ApplicationType> applicationTypes = new HashSet<ApplicationType>();
        List applicationTypeValues = StringPlus.asList((Object)this.get(serviceReference, "application-type"));
        for (String applicationTypeValue : applicationTypeValues) {
            try {
                ApplicationType applicationType = ApplicationType.parse((String)applicationTypeValue);
                applicationTypes.add(applicationType);
            }
            catch (IllegalArgumentException iae) {
                _log.error((Object)("Application type " + applicationTypeValue));
            }
        }
        if (applicationTypes.isEmpty()) {
            applicationTypes.add(ApplicationType.WIDGET);
        }
        portletModel.setApplicationTypes(applicationTypes);
    }

    protected void collectAsyncSupported(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        boolean asyncSupported = GetterUtil.getBoolean((Object)serviceReference.getProperty("javax.portlet.async-supported"));
        portletModel.setAsyncSupported(asyncSupported);
    }

    protected void collectCacheScope(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
    }

    protected void collectContainerRuntimeOptions(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        PortletApp portletApp = portletModel.getPortletApp();
        Map containerRuntimeOptionsMap = portletApp.getContainerRuntimeOptions();
        for (String servicePropertyKey : serviceReference.getPropertyKeys()) {
            if (!servicePropertyKey.startsWith("javax.portlet.container-runtime-option.")) continue;
            String name = servicePropertyKey.substring("javax.portlet.container-runtime-option.".length());
            String portletName = portletModel.getPortletName();
            int index = portletName.indexOf("_WAR_");
            if (index != -1) {
                portletName = portletName.substring(0, index);
            }
            String containerRuntimeOptionPrefix = LiferayPortletConfig.class.getName();
            containerRuntimeOptionPrefix = containerRuntimeOptionPrefix.concat(portletName);
            List values = StringPlus.asList((Object)serviceReference.getProperty(servicePropertyKey));
            containerRuntimeOptionsMap.put(containerRuntimeOptionPrefix.concat(name), values.toArray(new String[0]));
        }
    }

    protected void collectEventDefinitions(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        PortletApp portletApp = portletModel.getPortletApp();
        List definitions = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.event-definition"));
        for (String definition : definitions) {
            EventDefinitionImpl eventDefinition = null;
            String[] definitionParts = StringUtil.split((String)definition);
            for (int i = 0; i < definitionParts.length; ++i) {
                String event;
                String name = event = definitionParts[i];
                String qname = null;
                String[] parts = StringUtil.split((String)event, (char)';');
                if (parts.length >= 2) {
                    name = parts[0];
                    qname = parts[1];
                }
                QName qName = this.getQName(name, qname, portletApp.getDefaultNamespace());
                if (i == 0) {
                    String valueType = null;
                    if (parts.length == 3) {
                        valueType = parts[2];
                    }
                    eventDefinition = new EventDefinitionImpl(qName, valueType, portletApp);
                    continue;
                }
                eventDefinition.addAliasQName(qName);
            }
            if (eventDefinition == null) continue;
            portletApp.addEventDefinition(eventDefinition);
        }
    }

    protected void collectExpirationCache(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        int expirationCache = GetterUtil.getInteger((Object)serviceReference.getProperty("javax.portlet.expiration-cache"));
        portletModel.setExpCache(Integer.valueOf(expirationCache));
    }

    protected void collectInitParams(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (String initParamKey : serviceReference.getPropertyKeys()) {
            if (!initParamKey.startsWith("javax.portlet.init-param.")) continue;
            initParams.put(initParamKey.substring("javax.portlet.init-param.".length()), GetterUtil.getString((Object)serviceReference.getProperty(initParamKey)));
        }
        initParams.put("com.liferay.portal.invokerPortletName", "portlet-servlet");
        portletModel.setInitParams(initParams);
    }

    protected void collectJxPortletFeatures(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        this.collectApplicationTypes(serviceReference, portletModel);
        this.collectAsyncSupported(serviceReference, portletModel);
        this.collectCacheScope(serviceReference, portletModel);
        this.collectContainerRuntimeOptions(serviceReference, portletModel);
        this.collectEventDefinitions(serviceReference, portletModel);
        this.collectExpirationCache(serviceReference, portletModel);
        this.collectInitParams(serviceReference, portletModel);
        this.collectListeners(serviceReference, portletModel);
        this.collectMultipartConfig(serviceReference, portletModel);
        this.collectPortletDependencies(serviceReference, portletModel);
        this.collectPortletInfo(serviceReference, portletModel);
        this.collectPortletModes(serviceReference, portletModel);
        this.collectPortletPreferences(serviceReference, portletModel);
        this.collectResourceBundle(serviceReference, portletModel);
        this.collectSecurityRoleRefs(serviceReference, portletModel);
        this.collectSupportedLocales(serviceReference, portletModel);
        this.collectSupportedProcessingEvents(serviceReference, portletModel);
        this.collectSupportedPublicRenderParameters(serviceReference, portletModel);
        this.collectSupportedPublishingEvents(serviceReference, portletModel);
        this.collectWindowStates(serviceReference, portletModel);
    }

    protected void collectLiferayFeatures(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        portletModel.setActionTimeout(GetterUtil.getInteger((Object)this.get(serviceReference, "action-timeout"), (int)portletModel.getActionTimeout()));
        portletModel.setActionURLRedirect(GetterUtil.getBoolean((Object)this.get(serviceReference, "action-url-redirect"), (boolean)portletModel.getActionURLRedirect()));
        portletModel.setActive(GetterUtil.getBoolean((Object)this.get(serviceReference, "active"), (boolean)portletModel.isActive()));
        portletModel.setAddDefaultResource(GetterUtil.getBoolean((Object)this.get(serviceReference, "add-default-resource"), (boolean)portletModel.isAddDefaultResource()));
        portletModel.setAjaxable(GetterUtil.getBoolean((Object)this.get(serviceReference, "ajaxable"), (boolean)portletModel.isAjaxable()));
        Set autopropagatedParameters = SetUtil.fromCollection((Collection)StringPlus.asList((Object)this.get(serviceReference, "autopropagated-parameters")));
        portletModel.setAutopropagatedParameters(autopropagatedParameters);
        portletModel.setControlPanelEntryWeight(GetterUtil.getDouble((Object)this.get(serviceReference, "control-panel-entry-weight"), (double)portletModel.getControlPanelEntryWeight()));
        portletModel.setCssClassWrapper(GetterUtil.getString((Object)this.get(serviceReference, "css-class-wrapper"), (String)portletModel.getCssClassWrapper()));
        portletModel.setFooterPortalCss(StringPlus.asList((Object)this.get(serviceReference, "footer-portal-css")));
        portletModel.setFooterPortalJavaScript(StringPlus.asList((Object)this.get(serviceReference, "footer-portal-javascript")));
        portletModel.setFooterPortletCss(StringPlus.asList((Object)this.get(serviceReference, "footer-portlet-css")));
        portletModel.setFooterPortletJavaScript(StringPlus.asList((Object)this.get(serviceReference, "footer-portlet-javascript")));
        portletModel.setFriendlyURLMapping(GetterUtil.getString((Object)this.get(serviceReference, "friendly-url-mapping"), (String)portletModel.getFriendlyURLMapping()));
        portletModel.setFriendlyURLRoutes(GetterUtil.getString((Object)this.get(serviceReference, "friendly-url-routes"), (String)portletModel.getFriendlyURLRoutes()));
        portletModel.setHeaderPortalCss(StringPlus.asList((Object)this.get(serviceReference, "header-portal-css")));
        portletModel.setHeaderPortalJavaScript(StringPlus.asList((Object)this.get(serviceReference, "header-portal-javascript")));
        portletModel.setHeaderPortletCss(StringPlus.asList((Object)this.get(serviceReference, "header-portlet-css")));
        portletModel.setHeaderPortletJavaScript(StringPlus.asList((Object)this.get(serviceReference, "header-portlet-javascript")));
        portletModel.setHeaderRequestAttributePrefixes(StringPlus.asList((Object)this.get(serviceReference, "header-request-attribute-prefix")));
        portletModel.setHeaderTimeout(GetterUtil.getInteger((Object)this.get(serviceReference, "header-timeout"), (int)portletModel.getHeaderTimeout()));
        portletModel.setIcon(GetterUtil.getString((Object)this.get(serviceReference, "icon"), (String)portletModel.getIcon()));
        portletModel.setInclude(GetterUtil.getBoolean((Object)this.get(serviceReference, "include"), (boolean)portletModel.isInclude()));
        portletModel.setInstanceable(GetterUtil.getBoolean((Object)this.get(serviceReference, "instanceable"), (boolean)portletModel.isInstanceable()));
        portletModel.setLayoutCacheable(GetterUtil.getBoolean((Object)this.get(serviceReference, "layout-cacheable"), (boolean)portletModel.isLayoutCacheable()));
        portletModel.setMaximizeEdit(GetterUtil.getBoolean((Object)this.get(serviceReference, "maximize-edit"), (boolean)portletModel.isMaximizeEdit()));
        portletModel.setMaximizeHelp(GetterUtil.getBoolean((Object)this.get(serviceReference, "maximize-help"), (boolean)portletModel.isMaximizeHelp()));
        portletModel.setParentStrutsPath(GetterUtil.getString((Object)this.get(serviceReference, "parent-struts-path"), (String)portletModel.getParentStrutsPath()));
        portletModel.setPartialActionServeResource(GetterUtil.getBoolean((Object)this.get(serviceReference, "partial-action-serve-resource"), (boolean)portletModel.isPartialActionServeResource()));
        portletModel.setPopUpPrint(GetterUtil.getBoolean((Object)this.get(serviceReference, "pop-up-print"), (boolean)portletModel.isPopUpPrint()));
        portletModel.setPortletDependencyCssEnabled(GetterUtil.getBoolean((Object)this.get(serviceReference, "portlet-dependency-css-enabled"), (boolean)portletModel.isPortletDependencyCssEnabled()));
        portletModel.setPortletDependencyJavaScriptEnabled(GetterUtil.getBoolean((Object)this.get(serviceReference, "portlet-dependency-javascript-enabled"), (boolean)portletModel.isPortletDependencyJavaScriptEnabled()));
        portletModel.setPreferencesCompanyWide(GetterUtil.getBoolean((Object)this.get(serviceReference, "preferences-company-wide"), (boolean)portletModel.isPreferencesCompanyWide()));
        portletModel.setPreferencesOwnedByGroup(GetterUtil.getBoolean((Object)this.get(serviceReference, "preferences-owned-by-group"), (boolean)portletModel.isPreferencesOwnedByGroup()));
        portletModel.setPreferencesUniquePerLayout(GetterUtil.getBoolean((Object)this.get(serviceReference, "preferences-unique-per-layout"), (boolean)portletModel.isPreferencesUniquePerLayout()));
        portletModel.setPrivateRequestAttributes(GetterUtil.getBoolean((Object)this.get(serviceReference, "private-request-attributes"), (boolean)portletModel.isPrivateRequestAttributes()));
        portletModel.setPrivateSessionAttributes(GetterUtil.getBoolean((Object)this.get(serviceReference, "private-session-attributes"), (boolean)portletModel.isPrivateSessionAttributes()));
        portletModel.setRenderTimeout(GetterUtil.getInteger((Object)this.get(serviceReference, "render-timeout"), (int)portletModel.getRenderTimeout()));
        portletModel.setRenderWeight(GetterUtil.getInteger((Object)this.get(serviceReference, "render-weight"), (int)portletModel.getRenderWeight()));
        if (!portletModel.isAjaxable() && portletModel.getRenderWeight() < 1) {
            portletModel.setRenderWeight(1);
        }
        boolean defaultRequiresNamespacedParameters = GetterUtil.getBoolean((Object)this.get(serviceReference, "requires-namespaced-parameters"), (boolean)portletModel.isRequiresNamespacedParameters());
        portletModel.setRequiresNamespacedParameters(GetterUtil.getBoolean((Object)serviceReference.getProperty("requires-namespaced-parameters"), (boolean)defaultRequiresNamespacedParameters));
        portletModel.setRestoreCurrentView(GetterUtil.getBoolean((Object)this.get(serviceReference, "restore-current-view"), (boolean)portletModel.isRestoreCurrentView()));
        portletModel.setScopeable(GetterUtil.getBoolean((Object)this.get(serviceReference, "scopeable"), (boolean)portletModel.isScopeable()));
        portletModel.setShowPortletAccessDenied(GetterUtil.getBoolean((Object)this.get(serviceReference, "show-portlet-access-denied"), (boolean)portletModel.isShowPortletAccessDenied()));
        portletModel.setShowPortletInactive(GetterUtil.getBoolean((Object)this.get(serviceReference, "show-portlet-inactive"), (boolean)portletModel.isShowPortletInactive()));
        portletModel.setSinglePageApplication(GetterUtil.getBoolean((Object)this.get(serviceReference, "single-page-application"), (boolean)portletModel.isSinglePageApplication()));
        portletModel.setStrutsPath(GetterUtil.getString((Object)this.get(serviceReference, "struts-path"), (String)portletModel.getStrutsPath()));
        portletModel.setSystem(GetterUtil.getBoolean((Object)this.get(serviceReference, "system"), (boolean)portletModel.isSystem()));
        portletModel.setUseDefaultTemplate(GetterUtil.getBoolean((Object)this.get(serviceReference, "use-default-template"), (boolean)portletModel.isUseDefaultTemplate()));
        portletModel.setUserPrincipalStrategy(GetterUtil.getString((Object)this.get(serviceReference, "user-principal-strategy"), (String)portletModel.getUserPrincipalStrategy()));
        portletModel.setVirtualPath(GetterUtil.getString((Object)this.get(serviceReference, "virtual-path"), (String)portletModel.getVirtualPath()));
    }

    /*
     * WARNING - void declaration
     */
    protected void collectListeners(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        PortletApp portletApp = portletModel.getPortletApp();
        List listenerClassNames = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.listener"));
        ArrayList<PortletURLListenerImpl> portletURLListeners = new ArrayList<PortletURLListenerImpl>();
        for (String string : listenerClassNames) {
            void var7_7;
            int ordinal = 0;
            String[] parts = StringUtil.split((String)string, (char)';');
            if (parts.length == 2) {
                String string2 = parts[0];
                ordinal = GetterUtil.getInteger((String)parts[1]);
            }
            portletURLListeners.add(new PortletURLListenerImpl((String)var7_7, ordinal, portletApp));
        }
        Collections.sort(portletURLListeners, Comparator.comparingInt(PortletURLListener::getOrdinal));
        for (PortletURLListener portletURLListener : portletURLListeners) {
            portletApp.addPortletURLListener(portletURLListener);
        }
    }

    protected void collectMultipartConfig(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        portletModel.setMultipartFileSizeThreshold(GetterUtil.getInteger((Object)serviceReference.getProperty("javax.portlet.multipart.file-size-threshold")));
        portletModel.setMultipartLocation(GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.multipart.location"), (String)portletModel.getMultipartLocation()));
        portletModel.setMultipartMaxFileSize(GetterUtil.getLong((Object)serviceReference.getProperty("javax.portlet.multipart.max-file-size"), (long)-1L));
        portletModel.setMultipartMaxRequestSize(GetterUtil.getLong((Object)serviceReference.getProperty("javax.portlet.multipart.max-request-size"), (long)-1L));
    }

    protected void collectPortletDependencies(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        List dependencies = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.dependency"));
        for (String dependency : dependencies) {
            String[] parts = StringUtil.split((String)dependency, (char)';');
            portletModel.addPortletDependency(this._portletDependencyFactory.createPortletDependency(parts[0], parts[1], parts[2]));
        }
    }

    protected void collectPortletInfo(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        String portletInfoTitle = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.info.title"));
        String portletDisplayName = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.display-name"), (String)portletInfoTitle);
        String portletInfoShortTitle = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.info.short-title"));
        String portletInfoKeyWords = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.info.keywords"));
        String portletDescription = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.description"));
        PortletInfo portletInfo = new PortletInfo(portletDisplayName, portletInfoShortTitle, portletInfoKeyWords, portletDescription);
        portletModel.setPortletInfo(portletInfo);
    }

    protected void collectPortletModes(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashMap<String, Set> portletModes = new HashMap<String, Set>();
        portletModes.put("text/html", SetUtil.fromArray((Object[])new String[]{this.toLowerCase(PortletMode.VIEW)}));
        List portletModesStrings = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.portlet-mode"));
        for (String portletModesString : portletModesStrings) {
            String[] portletModesStringParts = StringUtil.split((String)portletModesString, (char)';');
            if (portletModesStringParts.length != 2) continue;
            String mimeType = portletModesStringParts[0];
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            mimeTypePortletModes.add(this.toLowerCase(PortletMode.VIEW));
            mimeTypePortletModes.addAll(this.toLowerCaseSet(portletModesStringParts[1]));
            portletModes.put(mimeType, mimeTypePortletModes);
        }
        portletModel.setPortletModes(portletModes);
    }

    protected void collectPortletPreferences(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        Bundle bundle;
        URL url;
        String defaultPreferences = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.preferences"));
        if (defaultPreferences != null && defaultPreferences.startsWith("classpath:") && (url = (bundle = serviceReference.getBundle()).getResource(defaultPreferences.substring("classpath:".length()))) != null) {
            try {
                defaultPreferences = StringUtil.read((InputStream)url.openStream());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        portletModel.setDefaultPreferences(defaultPreferences);
        String preferencesValidator = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.preferences-validator"));
        if (Validator.isNotNull((String)preferencesValidator)) {
            portletModel.setPreferencesValidator(preferencesValidator);
        }
    }

    protected void collectResourceBundle(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        String resourceBundle = GetterUtil.getString((Object)serviceReference.getProperty("javax.portlet.resource-bundle"), (String)portletModel.getResourceBundle());
        portletModel.setResourceBundle(resourceBundle);
    }

    protected void collectSecurityRoleRefs(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<String> unlinkedRoles = new HashSet<String>();
        List roleRefs = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.security-role-ref"));
        if (roleRefs.isEmpty()) {
            roleRefs.add("administrator");
            roleRefs.add("guest");
            roleRefs.add("power-user");
            roleRefs.add("user");
        }
        for (String roleRef : roleRefs) {
            for (String curRoleRef : StringUtil.split((String)roleRef)) {
                unlinkedRoles.add(curRoleRef);
            }
        }
        portletModel.setUnlinkedRoles(unlinkedRoles);
        portletModel.linkRoles();
    }

    protected void collectSupportedLocales(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        LinkedHashSet supportedLocales = new LinkedHashSet();
        supportedLocales.addAll(StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-locale")));
        portletModel.setSupportedLocales(supportedLocales);
    }

    protected void collectSupportedProcessingEvents(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<QName> processingEvents = new HashSet<QName>();
        PortletApp portletApp = portletModel.getPortletApp();
        List supportedProcessingEvents = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-processing-event"));
        Iterator iterator = supportedProcessingEvents.iterator();
        while (iterator.hasNext()) {
            String supportedProcessingEvent;
            String name = supportedProcessingEvent = (String)iterator.next();
            String qname = null;
            String[] parts = StringUtil.split((String)supportedProcessingEvent, (char)';');
            if (parts.length == 2) {
                name = parts[0];
                qname = parts[1];
            }
            QName qName = this.getQName(name, qname, portletApp.getDefaultNamespace());
            processingEvents.add(qName);
            Set eventDefinitions = portletApp.getEventDefinitions();
            for (EventDefinition eventDefinition : eventDefinitions) {
                Set qNames = eventDefinition.getQNames();
                if (!qNames.contains(qName)) continue;
                processingEvents.addAll(qNames);
            }
        }
        portletModel.setProcessingEvents(processingEvents);
    }

    protected void collectSupportedPublicRenderParameters(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<PublicRenderParameterImpl> publicRenderParameters = new HashSet<PublicRenderParameterImpl>();
        PortletApp portletApp = portletModel.getPortletApp();
        List supportedPublicRenderParameters = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-public-render-parameter"));
        Iterator iterator = supportedPublicRenderParameters.iterator();
        while (iterator.hasNext()) {
            String supportedPublicRenderParameter;
            String name = supportedPublicRenderParameter = (String)iterator.next();
            String qname = null;
            String[] parts = StringUtil.split((String)supportedPublicRenderParameter, (char)';');
            if (parts.length == 2) {
                name = parts[0];
                qname = parts[1];
            }
            QName qName = this.getQName(name, qname, portletApp.getDefaultNamespace());
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(name, qName, portletApp);
            publicRenderParameters.add(publicRenderParameter);
        }
        portletModel.setPublicRenderParameters(publicRenderParameters);
    }

    protected void collectSupportedPublishingEvents(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashSet<QName> publishingEvents = new HashSet<QName>();
        PortletApp portletApp = portletModel.getPortletApp();
        List supportedPublishingEvents = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.supported-publishing-event"));
        Iterator iterator = supportedPublishingEvents.iterator();
        while (iterator.hasNext()) {
            String supportedPublishingEvent;
            String name = supportedPublishingEvent = (String)iterator.next();
            String qname = null;
            String[] parts = StringUtil.split((String)supportedPublishingEvent, (char)';');
            if (parts.length == 2) {
                name = parts[0];
                qname = parts[1];
            }
            QName qName = this.getQName(name, qname, portletApp.getDefaultNamespace());
            publishingEvents.add(qName);
        }
        portletModel.setPublishingEvents(publishingEvents);
    }

    protected void collectWindowStates(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel) {
        HashMap<String, Set> windowStates = new HashMap<String, Set>();
        windowStates.put("text/html", SetUtil.fromArray((Object[])new String[]{this.toLowerCase(LiferayWindowState.EXCLUSIVE), this.toLowerCase(LiferayWindowState.POP_UP), this.toLowerCase(WindowState.MAXIMIZED), this.toLowerCase(WindowState.MINIMIZED), this.toLowerCase(WindowState.NORMAL)}));
        List windowStatesStrings = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.window-state"));
        for (String windowStatesString : windowStatesStrings) {
            String[] windowStatesStringParts = StringUtil.split((String)windowStatesString, (char)';');
            if (windowStatesStringParts.length != 2) continue;
            String mimeType = windowStatesStringParts[0];
            HashSet<String> mimeTypeWindowStates = new HashSet<String>();
            mimeTypeWindowStates.add(this.toLowerCase(WindowState.NORMAL));
            Set<String> windowStatesSet = this.toLowerCaseSet(windowStatesStringParts[1]);
            if (windowStatesSet.isEmpty()) {
                mimeTypeWindowStates.add(this.toLowerCase(LiferayWindowState.EXCLUSIVE));
                mimeTypeWindowStates.add(this.toLowerCase(LiferayWindowState.POP_UP));
                mimeTypeWindowStates.add(this.toLowerCase(WindowState.MAXIMIZED));
                mimeTypeWindowStates.add(this.toLowerCase(WindowState.MINIMIZED));
            } else {
                mimeTypeWindowStates.addAll(windowStatesSet);
            }
            windowStates.put(mimeType, mimeTypeWindowStates);
        }
        portletModel.setWindowStates(windowStates);
    }

    protected BundlePortletApp createBundlePortletApp(Bundle bundle, ClassLoader classLoader, ServiceRegistrations serviceRegistrations) {
        BundlePortletApp bundlePortletApp = serviceRegistrations.getBundlePortletApp();
        if (bundlePortletApp != null) {
            return bundlePortletApp;
        }
        com.liferay.portal.kernel.model.Portlet portalPortletModel = this._portletLocalService.getPortletById(0L, "90");
        BundleContext bundleContext = bundle.getBundleContext();
        this._servletContextHelperRegistrationServiceReference = bundleContext.getServiceReference(ServletContextHelperRegistration.class);
        ServletContextHelperRegistration servletContextHelperRegistration = (ServletContextHelperRegistration)bundleContext.getService(this._servletContextHelperRegistrationServiceReference);
        bundlePortletApp = new BundlePortletApp(bundle, portalPortletModel, servletContextHelperRegistration.getServletContext());
        serviceRegistrations.setBundlePortletApp(bundlePortletApp);
        serviceRegistrations.doConfiguration(classLoader);
        return bundlePortletApp;
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Deactivated");
        }
    }

    protected void deployPortlet(ServiceReference<Portlet> serviceReference, com.liferay.portal.kernel.model.Portlet portletModel, List<Company> companies) throws PortalException {
        List categoryNames = StringPlus.asList((Object)this.get(serviceReference, "display-category"));
        if (categoryNames.isEmpty()) {
            categoryNames.add("category.undefined");
        }
        String[] categoryNamesArray = ArrayUtil.toStringArray((Collection)categoryNames);
        for (Company company : companies) {
            com.liferay.portal.kernel.model.Portlet companyPortletModel = (com.liferay.portal.kernel.model.Portlet)portletModel.clone();
            companyPortletModel.setCompanyId(company.getCompanyId());
            this._portletLocalService.deployRemotePortlet(companyPortletModel, categoryNamesArray, false);
        }
    }

    protected Object get(ServiceReference<Portlet> serviceReference, String property) {
        return serviceReference.getProperty(_NAMESPACE + property);
    }

    protected QName getQName(String name, String uri, String defaultNamespace) {
        if (Validator.isNull((String)name) && Validator.isNull((String)uri)) {
            return null;
        }
        if (Validator.isNull((String)uri)) {
            return this._saxReader.createQName(name, this._saxReader.createNamespace(defaultNamespace));
        }
        return this._saxReader.createQName(name, this._saxReader.createNamespace(uri));
    }

    protected ServiceRegistrations getServiceRegistrations(Bundle bundle) {
        ServiceRegistrations oldServiceRegistrations;
        Long bundleId = bundle.getBundleId();
        ServiceRegistrations serviceRegistrations = (ServiceRegistrations)this._serviceRegistrations.get(bundleId);
        if (serviceRegistrations == null && (oldServiceRegistrations = this._serviceRegistrations.putIfAbsent(bundleId, serviceRegistrations = new ServiceRegistrations(bundle))) != null) {
            serviceRegistrations = oldServiceRegistrations;
        }
        return serviceRegistrations;
    }

    protected void readResourceActions(Configuration configuration, String servletContextName, ClassLoader classLoader) {
        if (configuration == null) {
            return;
        }
        Properties properties = configuration.getProperties();
        try {
            ResourceActionsUtil.read(null, (ClassLoader)classLoader, (String[])StringUtil.split((String)properties.getProperty("resource.actions.configs")));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setHttpServiceRuntime(HttpServiceRuntime httpServiceRuntime, Map<String, Object> properties) {
        List httpServiceEndpoints = StringPlus.asList((Object)properties.get("osgi.http.endpoint"));
        if (!httpServiceEndpoints.isEmpty()) {
            this._httpServiceEndpoint = (String)httpServiceEndpoints.get(0);
        }
        if (this._httpServiceEndpoint.length() > 0 && this._httpServiceEndpoint.endsWith("/")) {
            this._httpServiceEndpoint = this._httpServiceEndpoint.substring(0, this._httpServiceEndpoint.length() - 1);
        }
    }

    protected String toLowerCase(Object object) {
        String string = String.valueOf(object);
        return StringUtil.toLowerCase((String)string.trim());
    }

    protected Set<String> toLowerCaseSet(String string) {
        Object[] array = StringUtil.split((String)string);
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.toLowerCase(array[i]);
        }
        return SetUtil.fromArray((Object[])array);
    }

    private void _warnPorletProperties(String portletName, ServiceReference<Portlet> serviceReference) {
        if (!_log.isWarnEnabled()) {
            return;
        }
        List<String> invalidKeys = this._portletPropertyValidator.validate(serviceReference.getPropertyKeys());
        for (String invalidKey : invalidKeys) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Invalid property ", invalidKey, " for portlet ", portletName}));
        }
    }

    private class ServiceRegistrations {
        private final Bundle _bundle;
        private BundlePortletApp _bundlePortletApp;
        private Configuration _configuration;
        private final List<ServiceReference<Portlet>> _serviceReferences = new ArrayList<ServiceReference<Portlet>>();

        public synchronized void addServiceReference(ServiceReference<Portlet> serviceReference) {
            this._serviceReferences.add(serviceReference);
        }

        public synchronized void removeServiceReference(ServiceReference<Portlet> serviceReference) {
            this._serviceReferences.remove(serviceReference);
            if (!this._serviceReferences.isEmpty()) {
                return;
            }
            this._serviceReferences.clear();
            this._bundlePortletApp = null;
            PortletTracker.this._serviceRegistrations.remove(this._bundle.getBundleId());
            BundleContext bundleContext = this._bundle.getBundleContext();
            bundleContext.ungetService(PortletTracker.this._servletContextHelperRegistrationServiceReference);
        }

        public synchronized void setBundlePortletApp(BundlePortletApp bundlePortletApp) {
            this._bundlePortletApp = bundlePortletApp;
        }

        protected synchronized void doConfiguration(ClassLoader classLoader) {
            try {
                this._configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
            }
            catch (Exception exception) {
                // empty catch block
            }
            PortletTracker.this.readResourceActions(this._configuration, this._bundlePortletApp.getServletContextName(), classLoader);
        }

        protected synchronized BundlePortletApp getBundlePortletApp() {
            return this._bundlePortletApp;
        }

        private ServiceRegistrations(Bundle bundle) {
            this._bundle = bundle;
        }
    }
}

