/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.portlet.tracker.internal;

import com.liferay.portal.kernel.model.EventDefinition;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.SpriteImage;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.osgi.web.portlet.tracker.internal.BundlePluginPackage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;

public class BundlePortletApp
implements PortletApp {
    private String _defaultNamespace;
    private final Set<EventDefinition> _eventDefinitions = new HashSet<EventDefinition>();
    private final BundlePluginPackage _pluginPackage;
    private final Portlet _portalPortletModel;
    private final PortletApp _portletApp;
    private final Set<PortletURLListener> _portletURLListeners = new LinkedHashSet<PortletURLListener>();
    private final Map<String, PortletURLListener> _portletURLListenersMap = new HashMap<String, PortletURLListener>();
    private final ServletContext _servletContext;
    private int _specMajorVersion = 2;
    private int _specMinorVersion;
    private final Map<String, SpriteImage> _spriteImagesMap = new HashMap<String, SpriteImage>();
    private boolean _warFile = true;

    public BundlePortletApp(Bundle bundle, Portlet portalPortletModel, ServletContext servletContext) {
        this._portalPortletModel = portalPortletModel;
        this._servletContext = servletContext;
        this._pluginPackage = new BundlePluginPackage(bundle, this);
        this._portletApp = portalPortletModel.getPortletApp();
    }

    public void addEventDefinition(EventDefinition eventDefinition) {
        this._eventDefinitions.add(eventDefinition);
    }

    public void addPortlet(Portlet portlet) {
        this._portletApp.addPortlet(portlet);
    }

    public void addPortletFilter(PortletFilter portletFilter) {
        this._portletApp.addPortletFilter(portletFilter);
    }

    public void addPortletURLListener(PortletURLListener portletURLListener) {
        this._portletURLListeners.add(portletURLListener);
        this._portletURLListenersMap.put(portletURLListener.getListenerClass(), portletURLListener);
    }

    public void addPublicRenderParameter(PublicRenderParameter publicRenderParameter) {
        this._portletApp.addPublicRenderParameter(publicRenderParameter);
    }

    public void addPublicRenderParameter(String identifier, QName qName) {
        this._portletApp.addPublicRenderParameter(identifier, qName);
    }

    public void addServletURLPatterns(Set<String> servletURLPatterns) {
        this._portletApp.addServletURLPatterns(servletURLPatterns);
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        return this._portletApp.getContainerRuntimeOptions();
    }

    public String getContextPath() {
        ServletContext servletContext = this.getServletContext();
        return servletContext.getContextPath();
    }

    public Map<String, String> getCustomUserAttributes() {
        return this._portletApp.getCustomUserAttributes();
    }

    public String getDefaultNamespace() {
        if (this._defaultNamespace == null) {
            return this._portletApp.getDefaultNamespace();
        }
        return this._defaultNamespace;
    }

    public Set<EventDefinition> getEventDefinitions() {
        return this._eventDefinitions;
    }

    public BundlePluginPackage getPluginPackage() {
        return this._pluginPackage;
    }

    public PortletFilter getPortletFilter(String filterName) {
        return this._portletApp.getPortletFilter(filterName);
    }

    public Set<PortletFilter> getPortletFilters() {
        return this._portletApp.getPortletFilters();
    }

    public List<Portlet> getPortlets() {
        return this._portletApp.getPortlets();
    }

    public PortletURLListener getPortletURLListener(String listenerClass) {
        return this._portletURLListenersMap.get(listenerClass);
    }

    public Set<PortletURLListener> getPortletURLListeners() {
        return this._portletURLListeners;
    }

    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        return this._portletApp.getPublicRenderParameter(identifier);
    }

    public Map<String, String> getRoleMappers() {
        return this._portalPortletModel.getRoleMappers();
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public String getServletContextName() {
        ServletContext servletContext = this.getServletContext();
        return servletContext.getServletContextName();
    }

    public Set<String> getServletURLPatterns() {
        return this._portletApp.getServletURLPatterns();
    }

    public int getSpecMajorVersion() {
        return this._specMajorVersion;
    }

    public int getSpecMinorVersion() {
        return this._specMinorVersion;
    }

    public SpriteImage getSpriteImage(String fileName) {
        return this._spriteImagesMap.get(fileName);
    }

    public Set<String> getUserAttributes() {
        return this._portletApp.getUserAttributes();
    }

    public boolean isWARFile() {
        return this._warFile;
    }

    public void removePortlet(Portlet portletModel) {
        this._portletApp.removePortlet(portletModel);
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this._defaultNamespace = Validator.isNull((String)defaultNamespace) ? null : defaultNamespace;
    }

    public void setServletContext(ServletContext servletContext) {
        throw new UnsupportedOperationException();
    }

    public void setSpecMajorVersion(int specMajorVersion) {
        this._specMajorVersion = specMajorVersion;
    }

    public void setSpecMinorVersion(int specMinorVersion) {
        this._specMinorVersion = specMinorVersion;
    }

    public void setSpriteImages(String spriteFileName, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int[] values = StringUtil.split((String)value, (int)0);
            int offset = values[0];
            int height = values[1];
            int width = values[2];
            SpriteImage spriteImage = new SpriteImage(spriteFileName, key, offset, height, width);
            this._spriteImagesMap.put(key, spriteImage);
        }
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }
}

