/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.debug.declarative.service.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.osgi.debug.declarative.service.internal.UnsatisfiedComponentUtil;
import com.liferay.portal.osgi.debug.declarative.service.internal.configuration.UnsatisfiedComponentScannerConfiguration;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;

@Component(configurationPid={"com.liferay.portal.osgi.debug.declarative.service.internal.configuration.UnsatisfiedComponentScannerConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class UnsatisfiedComponentScanner {
    private static final Log _log = LogFactoryUtil.getLog(UnsatisfiedComponentScanner.class);
    @Reference
    private ServiceComponentRuntime _serviceComponentRuntime;
    private Thread _unsatisfiedComponentScanningThread;

    @Activate
    protected void activate(ComponentContext componentContext) {
        UnsatisfiedComponentScannerConfiguration unsatisfiedComponentScannerConfiguration = (UnsatisfiedComponentScannerConfiguration)ConfigurableUtil.createConfigurable(UnsatisfiedComponentScannerConfiguration.class, (Dictionary)componentContext.getProperties());
        long scanningInterval = unsatisfiedComponentScannerConfiguration.unsatisfiedComponentScanningInterval();
        if (scanningInterval > 0L) {
            this._unsatisfiedComponentScanningThread = new UnsatisfiedComponentScanningThread(scanningInterval * 1000L, this._serviceComponentRuntime);
            this._unsatisfiedComponentScanningThread.start();
        }
    }

    @Deactivate
    protected void deactivate() throws InterruptedException {
        if (this._unsatisfiedComponentScanningThread != null) {
            this._unsatisfiedComponentScanningThread.interrupt();
            this._unsatisfiedComponentScanningThread.join();
        }
    }

    private static void _scanUnsatisfiedComponents(ServiceComponentRuntime serviceComponentRuntime) {
        if (_log.isInfoEnabled()) {
            Bundle bundle = FrameworkUtil.getBundle(UnsatisfiedComponentScanner.class);
            BundleContext bundleContext = bundle.getBundleContext();
            String message = UnsatisfiedComponentUtil.listUnsatisfiedComponents(serviceComponentRuntime, bundleContext.getBundles());
            if (message.isEmpty()) {
                _log.info((Object)"All declarative service components are satisfied");
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)message);
            }
        }
    }

    private static class UnsatisfiedComponentScanningThread
    extends Thread {
        private final long _scanningInterval;
        private final ServiceComponentRuntime _serviceComponentRuntime;

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(this._scanningInterval);
                    UnsatisfiedComponentScanner._scanUnsatisfiedComponents(this._serviceComponentRuntime);
                }
            }
            catch (InterruptedException interruptedException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Stopped scanning for unsatisfied declarative service components", (Throwable)interruptedException);
                }
                return;
            }
        }

        private UnsatisfiedComponentScanningThread(long scanningInterval, ServiceComponentRuntime serviceComponentRuntime) {
            this._scanningInterval = scanningInterval;
            this._serviceComponentRuntime = serviceComponentRuntime;
            this.setDaemon(true);
            this.setName("Declarative Service Unsatisfied Component Scanner");
        }
    }
}

