/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.filter.expression;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodExpressionImpl
implements MethodExpression {
    private final List<Expression> _expressions;
    private final MethodExpression.Type _type;

    public MethodExpressionImpl(List<Expression> expressions, MethodExpression.Type type) {
        this._expressions = expressions == null ? Collections.emptyList() : Collections.unmodifiableList(expressions);
        this._type = type;
    }

    public <T> T accept(ExpressionVisitor<T> expressionVisitor) throws ExpressionVisitException {
        ArrayList<Object> expressions = new ArrayList<Object>();
        for (Expression expression : this._expressions) {
            expressions.add(expression.accept(expressionVisitor));
        }
        return (T)expressionVisitor.visitMethodExpression(Collections.unmodifiableList(expressions), this._type);
    }

    public List<Expression> getExpressions() {
        return this._expressions;
    }

    public MethodExpression.Type getType() {
        return this._type;
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{", this._type, " ", this._expressions, "}"});
    }
}

