/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.filter.expression;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.ListExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.NavigationPropertyExpression;
import com.liferay.portal.odata.filter.expression.PropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import com.liferay.portal.odata.filter.expression.factory.ExpressionFactory;
import com.liferay.portal.odata.internal.filter.expression.NullLiteralExpression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;

public class ExpressionVisitorImpl
implements ExpressionVisitor<com.liferay.portal.odata.filter.expression.Expression> {
    private final ExpressionFactory _expressionFactory;

    public ExpressionVisitorImpl(ExpressionFactory expressionFactory) {
        this._expressionFactory = expressionFactory;
    }

    public com.liferay.portal.odata.filter.expression.Expression visitAlias(String alias) {
        throw new UnsupportedOperationException("Alias: " + alias);
    }

    public com.liferay.portal.odata.filter.expression.Expression visitBinaryOperator(BinaryOperatorKind binaryOperatorKind, com.liferay.portal.odata.filter.expression.Expression leftBinaryOperationExpression, com.liferay.portal.odata.filter.expression.Expression rightBinaryOperationExpression) {
        BinaryExpression.Operation binaryExpressionOperation = null;
        if (binaryOperatorKind == BinaryOperatorKind.AND) {
            binaryExpressionOperation = BinaryExpression.Operation.AND;
        } else if (binaryOperatorKind == BinaryOperatorKind.EQ) {
            binaryExpressionOperation = BinaryExpression.Operation.EQ;
        } else if (binaryOperatorKind == BinaryOperatorKind.GE) {
            binaryExpressionOperation = BinaryExpression.Operation.GE;
        } else if (binaryOperatorKind == BinaryOperatorKind.GT) {
            binaryExpressionOperation = BinaryExpression.Operation.GT;
        } else if (binaryOperatorKind == BinaryOperatorKind.LE) {
            binaryExpressionOperation = BinaryExpression.Operation.LE;
        } else if (binaryOperatorKind == BinaryOperatorKind.LT) {
            binaryExpressionOperation = BinaryExpression.Operation.LT;
        } else if (binaryOperatorKind == BinaryOperatorKind.NE) {
            binaryExpressionOperation = BinaryExpression.Operation.NE;
        } else if (binaryOperatorKind == BinaryOperatorKind.OR) {
            binaryExpressionOperation = BinaryExpression.Operation.OR;
        } else {
            throw new UnsupportedOperationException("Binary operator: " + binaryOperatorKind);
        }
        return this._expressionFactory.createBinaryExpression(leftBinaryOperationExpression, binaryExpressionOperation, rightBinaryOperationExpression);
    }

    public com.liferay.portal.odata.filter.expression.Expression visitBinaryOperator(BinaryOperatorKind binaryOperatorKind, com.liferay.portal.odata.filter.expression.Expression leftListOperationExpression, List<com.liferay.portal.odata.filter.expression.Expression> rightListOperationExpressions) {
        if (binaryOperatorKind == BinaryOperatorKind.IN) {
            return this._expressionFactory.createListExpression(leftListOperationExpression, ListExpression.Operation.IN, rightListOperationExpressions);
        }
        throw new UnsupportedOperationException("Binary operator: " + binaryOperatorKind);
    }

    public com.liferay.portal.odata.filter.expression.Expression visitEnum(EdmEnumType edmEnumType, List<String> list) {
        throw new UnsupportedOperationException("Enum: " + StringUtil.merge((Collection)edmEnumType.getMemberNames()));
    }

    public com.liferay.portal.odata.filter.expression.Expression visitLambdaExpression(String lambdaFunction, String lambdaVariable, Expression expression) throws ExpressionVisitException, ODataApplicationException {
        if (Objects.equals(StringUtil.toUpperCase((String)lambdaFunction), LambdaFunctionExpression.Type.ANY.name())) {
            com.liferay.portal.odata.filter.expression.Expression lambdaFunctionExpression = null;
            if (expression != null) {
                lambdaFunctionExpression = (com.liferay.portal.odata.filter.expression.Expression)expression.accept((ExpressionVisitor)this);
            }
            return this._expressionFactory.createLambdaFunctionExpression(LambdaFunctionExpression.Type.ANY, lambdaVariable, lambdaFunctionExpression);
        }
        throw new UnsupportedOperationException("Lambda expression: " + lambdaFunction);
    }

    public com.liferay.portal.odata.filter.expression.Expression visitLambdaReference(String lambdaReference) {
        throw new UnsupportedOperationException("Lambda reference: " + lambdaReference);
    }

    public com.liferay.portal.odata.filter.expression.Expression visitLiteral(Literal literal) {
        EdmType edmType = literal.getType();
        if (edmType instanceof EdmBoolean) {
            return this._expressionFactory.createLiteralExpression(literal.getText(), LiteralExpression.Type.BOOLEAN);
        }
        if (edmType instanceof EdmByte || edmType instanceof EdmInt16 || edmType instanceof EdmInt32 || edmType instanceof EdmInt64 || edmType instanceof EdmSByte) {
            return this._expressionFactory.createLiteralExpression(literal.getText(), LiteralExpression.Type.INTEGER);
        }
        if (edmType instanceof EdmDate) {
            return this._expressionFactory.createLiteralExpression(literal.getText(), LiteralExpression.Type.DATE);
        }
        if (edmType instanceof EdmDateTimeOffset) {
            return this._expressionFactory.createLiteralExpression(literal.getText(), LiteralExpression.Type.DATE_TIME);
        }
        if (edmType instanceof EdmDecimal || edmType instanceof EdmDouble) {
            return this._expressionFactory.createLiteralExpression(literal.getText(), LiteralExpression.Type.DOUBLE);
        }
        if (edmType instanceof EdmString) {
            return this._expressionFactory.createLiteralExpression(literal.getText(), LiteralExpression.Type.STRING);
        }
        if (edmType == null || Objects.equals(literal.getText(), "null")) {
            return new NullLiteralExpression();
        }
        throw new UnsupportedOperationException("Literal: " + edmType.getFullQualifiedName());
    }

    public com.liferay.portal.odata.filter.expression.Expression visitMember(Member member) throws ExpressionVisitException {
        UriInfoResource uriInfoResource = member.getResourcePath();
        return this._expressionFactory.createMemberExpression(this._getExpression(uriInfoResource.getUriResourceParts()));
    }

    public com.liferay.portal.odata.filter.expression.Expression visitMethodCall(MethodKind methodKind, List<com.liferay.portal.odata.filter.expression.Expression> expressions) {
        if (methodKind == MethodKind.CONTAINS) {
            return this._expressionFactory.createMethodExpression(expressions, MethodExpression.Type.CONTAINS);
        }
        if (methodKind == MethodKind.NOW) {
            return this._expressionFactory.createMethodExpression(expressions, MethodExpression.Type.NOW);
        }
        if (methodKind == MethodKind.STARTSWITH) {
            return this._expressionFactory.createMethodExpression(expressions, MethodExpression.Type.STARTS_WITH);
        }
        throw new UnsupportedOperationException("Method call: " + methodKind);
    }

    public com.liferay.portal.odata.filter.expression.Expression visitTypeLiteral(EdmType edmType) {
        throw new UnsupportedOperationException("Type literal: " + edmType.getKind());
    }

    public com.liferay.portal.odata.filter.expression.Expression visitUnaryOperator(UnaryOperatorKind unaryOperatorKind, com.liferay.portal.odata.filter.expression.Expression expression) {
        if (unaryOperatorKind == UnaryOperatorKind.NOT) {
            return this._expressionFactory.createUnaryExpression(expression, UnaryExpression.Operation.NOT);
        }
        throw new UnsupportedOperationException("Unary operator: " + unaryOperatorKind);
    }

    private com.liferay.portal.odata.filter.expression.Expression _getExpression(List<UriResource> uriResources) throws ExpressionVisitException {
        UriResourcePartTyped uriResourcePartTyped;
        UriResource uriResource = uriResources.get(0);
        if (uriResources.size() == 1 && uriResource instanceof UriResourcePrimitiveProperty) {
            return this._expressionFactory.createPrimitivePropertyExpression(uriResource.getSegmentValue());
        }
        if (uriResources.size() > 1 && uriResource instanceof UriResourceComplexProperty) {
            return this._expressionFactory.createComplexPropertyExpression(uriResource.getSegmentValue(), (PropertyExpression)this._getExpression(uriResources.subList(1, uriResources.size())));
        }
        if (uriResources.size() > 1 && uriResource instanceof UriResourceNavigation) {
            return this._expressionFactory.createNavigationPropertyExpression(uriResource.getSegmentValue(), this._getType(uriResources.get(1)));
        }
        if (uriResources.size() > 1 && uriResource instanceof UriResourcePrimitiveProperty) {
            UriResource lambdaUriResource = uriResources.get(uriResources.size() - 1);
            if (lambdaUriResource instanceof UriResourceLambdaAny) {
                UriResourceLambdaAny uriResourceLambdaAny = (UriResourceLambdaAny)lambdaUriResource;
                try {
                    return this._expressionFactory.createCollectionPropertyExpression((LambdaFunctionExpression)this.visitLambdaExpression(LambdaFunctionExpression.Type.ANY.name(), uriResourceLambdaAny.getLambdaVariable(), uriResourceLambdaAny.getExpression()), (PropertyExpression)this._getExpression(uriResources.subList(0, uriResources.size() - 1)));
                }
                catch (ODataApplicationException oDataApplicationException) {
                    throw new ExpressionVisitException((Throwable)oDataApplicationException);
                }
            }
        } else if (uriResource instanceof UriResourcePartTyped && Objects.equals((uriResourcePartTyped = (UriResourcePartTyped)uriResource).getKind(), UriResourceKind.lambdaVariable)) {
            return this._expressionFactory.createLambdaVariableExpression(uriResource.getSegmentValue());
        }
        throw new UnsupportedOperationException("An expression cannot be obtained from URI resources " + uriResources);
    }

    private NavigationPropertyExpression.Type _getType(UriResource uriResource) {
        if (uriResource instanceof UriResourceCount) {
            return NavigationPropertyExpression.Type.COUNT;
        }
        return NavigationPropertyExpression.Type.SIMPLE;
    }
}

