/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.filter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.factory.ExpressionFactory;
import com.liferay.portal.odata.internal.filter.EntityModelSchemaBasedEdmProvider;
import com.liferay.portal.odata.internal.filter.expression.ExpressionVisitorImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.commons.core.edm.EdmProviderImpl;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;

public class FilterParserImpl
implements FilterParser {
    private static final Log _log = LogFactoryUtil.getLog(FilterParserImpl.class);
    private final ExpressionFactory _expressionFactory;
    private final Parser _parser;
    private final String _path;

    public FilterParserImpl(EntityModel entityModel, ExpressionFactory expressionFactory) {
        this._expressionFactory = expressionFactory;
        this._parser = new Parser((Edm)new EdmProviderImpl((CsdlEdmProvider)new EntityModelSchemaBasedEdmProvider(entityModel)), OData.newInstance());
        this._path = entityModel.getName();
    }

    public com.liferay.portal.odata.filter.expression.Expression parse(String filterString) throws ExpressionVisitException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Parsing filter: " + filterString));
        }
        if (Validator.isNull((String)filterString)) {
            throw new ExpressionVisitException("Filter is null");
        }
        UriInfo uriInfo = this._getUriInfo(filterString);
        FilterOption filterOption = uriInfo.getFilterOption();
        Expression expression = filterOption.getExpression();
        try {
            return (com.liferay.portal.odata.filter.expression.Expression)expression.accept((ExpressionVisitor)new ExpressionVisitorImpl(this._expressionFactory));
        }
        catch (Exception exception) {
            throw new ExpressionVisitException(exception.getMessage(), (Throwable)exception);
        }
    }

    private UriInfo _getUriInfo(String filterString) throws ExpressionVisitException {
        try {
            return this._parser.parseUri(this._path, "$filter=" + Encoder.encode((String)filterString), null, null);
        }
        catch (UriParserSemanticException uriParserSemanticException) {
            String message = uriParserSemanticException.getMessage();
            if (UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE.equals((Object)uriParserSemanticException.getMessageKey())) {
                message = "A property used in the filter criteria is not supported: " + filterString;
            }
            throw new ExpressionVisitException(message, (Throwable)uriParserSemanticException);
        }
        catch (ODataException oDataException) {
            throw new ExpressionVisitException(oDataException.getMessage(), (Throwable)oDataException);
        }
    }
}

