/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.tracker;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class ParserRegistrar {
    @Reference
    private FilterParserProvider _filterParserProvider;
    private ServiceTracker<?, ?> _serviceTracker;
    @Reference
    private SortParserProvider _sortParserProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, EntityModel.class, (ServiceTrackerCustomizer)new EntityModelTrackerCustomizer(bundleContext, this._filterParserProvider, this._sortParserProvider));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private static class ParserServiceRegistrations {
        private final Object _entityModelName;
        private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

        public <T> void register(BundleContext bundleContext, Class<T> clazz, T parser) {
            ServiceRegistration serviceRegistration = bundleContext.registerService(clazz, parser, (Dictionary)HashMapDictionaryBuilder.put((Object)"entity.model.name", (Object)this._entityModelName).build());
            this._serviceRegistrations.add(serviceRegistration);
        }

        public void unregister() {
            for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }

        private ParserServiceRegistrations(Object entityModelName) {
            this._entityModelName = entityModelName;
        }
    }

    private static class EntityModelTrackerCustomizer
    implements ServiceTrackerCustomizer<EntityModel, ParserServiceRegistrations> {
        private final BundleContext _bundleContext;
        private final FilterParserProvider _filterParserProvider;
        private final SortParserProvider _sortParserProvider;

        public ParserServiceRegistrations addingService(ServiceReference<EntityModel> serviceReference) {
            EntityModel entityModel = (EntityModel)this._bundleContext.getService(serviceReference);
            ParserServiceRegistrations parserServiceRegistrations = new ParserServiceRegistrations(serviceReference.getProperty("entity.model.name"));
            try {
                parserServiceRegistrations.register(this._bundleContext, FilterParser.class, this._filterParserProvider.provide(entityModel));
                parserServiceRegistrations.register(this._bundleContext, SortParser.class, this._sortParserProvider.provide(entityModel));
            }
            catch (Throwable throwable) {
                parserServiceRegistrations.unregister();
                this._bundleContext.ungetService(serviceReference);
                throw throwable;
            }
            return parserServiceRegistrations;
        }

        public void modifiedService(ServiceReference<EntityModel> serviceReference, ParserServiceRegistrations parserServiceRegistrations) {
            if (!Objects.equals(serviceReference.getProperty("entity.model.name"), parserServiceRegistrations._entityModelName)) {
                this.removedService(serviceReference, parserServiceRegistrations);
                this.addingService((ServiceReference)serviceReference);
            }
        }

        public void removedService(ServiceReference<EntityModel> serviceReference, ParserServiceRegistrations parserServiceRegistrations) {
            this._bundleContext.ungetService(serviceReference);
            parserServiceRegistrations.unregister();
        }

        private EntityModelTrackerCustomizer(BundleContext bundleContext, FilterParserProvider filterParserProvider, SortParserProvider sortParserProvider) {
            this._bundleContext = bundleContext;
            this._filterParserProvider = filterParserProvider;
            this._sortParserProvider = sortParserProvider;
        }
    }
}

