/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.filter;

import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.server.core.SchemaBasedEdmProvider;

public class EntityModelSchemaBasedEdmProvider
extends SchemaBasedEdmProvider {
    private static final String _NAMESPACE = "HypermediaRestApis";

    public EntityModelSchemaBasedEdmProvider(EntityModel entityModel) {
        this.addSchema(this._createCsdlSchema(_NAMESPACE, entityModel.getName(), this._createCsdlProperties(_NAMESPACE, entityModel.getEntityFieldsMap()), this._createCsdlComplexTypes(_NAMESPACE, entityModel.getEntityFieldsMap())));
    }

    private CsdlProperty _createCollectionCsdlProperty(EntityField entityField, FullQualifiedName fullQualifiedName) {
        CsdlProperty csdlProperty = new CsdlProperty();
        csdlProperty.setCollection(true);
        csdlProperty.setName(entityField.getName());
        csdlProperty.setType(fullQualifiedName);
        return csdlProperty;
    }

    private CsdlComplexType _createCsdlComplexType(String namespace, EntityField entityField) {
        if (!Objects.equals(entityField.getType(), EntityField.Type.COMPLEX)) {
            return null;
        }
        ComplexEntityField complexEntityField = (ComplexEntityField)entityField;
        CsdlComplexType csdlComplexType = new CsdlComplexType();
        csdlComplexType.setName(entityField.getName());
        Map entityFieldsMap = complexEntityField.getEntityFieldsMap();
        ArrayList<CsdlProperty> csdlProperties = new ArrayList<CsdlProperty>(entityFieldsMap.size());
        for (EntityField curEntityField : entityFieldsMap.values()) {
            CsdlProperty csdlProperty = this._createCsdlProperty(namespace, curEntityField);
            if (csdlProperty == null) continue;
            csdlProperties.add(csdlProperty);
        }
        csdlComplexType.setProperties(csdlProperties);
        return csdlComplexType;
    }

    private List<CsdlComplexType> _createCsdlComplexTypes(String namespace, Map<String, EntityField> entityFieldsMap) {
        ArrayList<CsdlComplexType> csdlComplexTypes = new ArrayList<CsdlComplexType>(entityFieldsMap.size());
        for (EntityField entityField : entityFieldsMap.values()) {
            CsdlComplexType csdlComplexType = this._createCsdlComplexType(namespace, entityField);
            if (csdlComplexType == null) continue;
            csdlComplexTypes.add(csdlComplexType);
        }
        return csdlComplexTypes;
    }

    private CsdlEntityContainer _createCsdlEntityContainer(String namespace, String name) {
        CsdlEntityContainer csdlEntityContainer = new CsdlEntityContainer();
        csdlEntityContainer.setEntitySets(this._createCsdlEntitySets(namespace, name));
        csdlEntityContainer.setName(name);
        return csdlEntityContainer;
    }

    private List<CsdlEntitySet> _createCsdlEntitySets(String namespace, String entityNameType) {
        CsdlEntitySet csdlEntitySet = new CsdlEntitySet();
        csdlEntitySet.setName(entityNameType);
        csdlEntitySet.setType(new FullQualifiedName(namespace, entityNameType));
        return Collections.singletonList(csdlEntitySet);
    }

    private CsdlEntityType _createCsdlEntityType(String name, List<CsdlProperty> csdlProperties) {
        CsdlEntityType csdlEntityType = new CsdlEntityType();
        csdlEntityType.setName(name);
        csdlEntityType.setProperties(csdlProperties);
        return csdlEntityType;
    }

    private List<CsdlProperty> _createCsdlProperties(String namespace, Map<String, EntityField> entityFieldsMap) {
        ArrayList<CsdlProperty> csdlProperties = new ArrayList<CsdlProperty>(entityFieldsMap.size());
        for (EntityField entityField : entityFieldsMap.values()) {
            CsdlProperty csdlProperty = this._createCsdlProperty(namespace, entityField);
            if (csdlProperty == null) continue;
            csdlProperties.add(csdlProperty);
        }
        return csdlProperties;
    }

    private CsdlProperty _createCsdlProperty(String namespace, EntityField entityField) {
        if (Objects.equals(entityField.getType(), EntityField.Type.COMPLEX)) {
            CsdlProperty csdlProperty = new CsdlProperty();
            csdlProperty.setName(entityField.getName());
            csdlProperty.setType(new FullQualifiedName(namespace, entityField.getName()));
            return csdlProperty;
        }
        FullQualifiedName fullQualifiedName = this._getFullQualifiedName(entityField);
        if (fullQualifiedName == null) {
            return null;
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.COLLECTION)) {
            return this._createCollectionCsdlProperty(entityField, fullQualifiedName);
        }
        return this._createPrimitiveCsdlProperty(entityField, fullQualifiedName);
    }

    private CsdlSchema _createCsdlSchema(String namespace, String name, List<CsdlProperty> csdlProperties, List<CsdlComplexType> csdlComplexTypes) {
        CsdlSchema csdlSchema = new CsdlSchema();
        csdlSchema.setComplexTypes(csdlComplexTypes);
        csdlSchema.setEntityContainer(this._createCsdlEntityContainer(namespace, name));
        csdlSchema.setEntityTypes(Collections.singletonList(this._createCsdlEntityType(name, csdlProperties)));
        csdlSchema.setNamespace(namespace);
        return csdlSchema;
    }

    private CsdlProperty _createPrimitiveCsdlProperty(EntityField entityField, FullQualifiedName fullQualifiedName) {
        CsdlProperty csdlProperty = new CsdlProperty();
        csdlProperty.setName(entityField.getName());
        csdlProperty.setType(fullQualifiedName);
        return csdlProperty;
    }

    private FullQualifiedName _getFullQualifiedName(EntityField entityField) {
        if (Objects.equals(entityField.getType(), EntityField.Type.BOOLEAN)) {
            return EdmPrimitiveTypeKind.Boolean.getFullQualifiedName();
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.COLLECTION)) {
            CollectionEntityField collectionEntityField = (CollectionEntityField)entityField;
            return this._getFullQualifiedName(collectionEntityField.getEntityField());
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.DATE)) {
            return EdmPrimitiveTypeKind.Date.getFullQualifiedName();
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME)) {
            return EdmPrimitiveTypeKind.DateTimeOffset.getFullQualifiedName();
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.DOUBLE)) {
            return EdmPrimitiveTypeKind.Double.getFullQualifiedName();
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.ID) || Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return EdmPrimitiveTypeKind.String.getFullQualifiedName();
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.INTEGER)) {
            return EdmPrimitiveTypeKind.Int64.getFullQualifiedName();
        }
        return null;
    }
}

