/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.sort;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.sort.InvalidSortException;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SortParserImpl
implements SortParser {
    private static final boolean _ASC_DEFAULT = true;
    private static final String _ORDER_BY_ASC = "asc";
    private static final String _ORDER_BY_DESC = "desc";
    private final EntityModel _entityModel;

    public SortParserImpl(EntityModel entityModel) {
        this._entityModel = entityModel;
    }

    public List<SortField> parse(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return Collections.emptyList();
        }
        List list = com.liferay.petra.string.StringUtil.split((String)sortString);
        Stream stream = list.stream();
        return stream.map(this::getSortFieldOptional).flatMap(sortFieldOptional -> sortFieldOptional.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    protected Optional<EntityField> getEntityFieldOptional(Map<String, EntityField> entityFieldsMap, String fieldName) {
        if (fieldName.contains("/")) {
            List list = com.liferay.petra.string.StringUtil.split((String)fieldName, (char)'/');
            String complexTypeName = (String)list.get(0);
            EntityField entityField = entityFieldsMap.get(complexTypeName);
            if (entityField == null || !Objects.equals(EntityField.Type.COMPLEX, entityField.getType())) {
                throw new InvalidSortException("Unable to sort because \"" + fieldName + "\" is not a complex property");
            }
            ComplexEntityField complexEntityField = (ComplexEntityField)entityField;
            return this.getEntityFieldOptional(complexEntityField.getEntityFieldsMap(), fieldName.substring(complexTypeName.length() + 1));
        }
        return Optional.ofNullable(entityFieldsMap.get(fieldName));
    }

    protected Optional<SortField> getSortFieldOptional(String sortString) {
        List list = com.liferay.petra.string.StringUtil.split((String)sortString, (char)':');
        if (list.isEmpty()) {
            return Optional.empty();
        }
        if (list.size() > 2) {
            throw new InvalidSortException("Unable to parse sort string: " + sortString);
        }
        String fieldName = (String)list.get(0);
        boolean ascending = list.size() > 1 ? this.isAscending((String)list.get(1)) : true;
        if (this._entityModel == null) {
            return Optional.of(new SortField(fieldName, ascending));
        }
        Optional<EntityField> entityFieldOptional = this.getEntityFieldOptional(this._entityModel.getEntityFieldsMap(), fieldName);
        return entityFieldOptional.map(entityField -> Optional.of(new SortField(entityField, ascending))).orElseThrow(() -> new InvalidSortException("Unable to sort by property: " + fieldName));
    }

    protected boolean isAscending(String orderBy) {
        if (orderBy == null) {
            return true;
        }
        if (_ORDER_BY_ASC.equals(StringUtil.toLowerCase((String)orderBy))) {
            return true;
        }
        return !_ORDER_BY_DESC.equals(StringUtil.toLowerCase((String)orderBy));
    }
}

