/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.olingo.server.core;

import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoAll;
import org.apache.olingo.server.api.uri.UriInfoBatch;
import org.apache.olingo.server.api.uri.UriInfoCrossjoin;
import org.apache.olingo.server.api.uri.UriInfoEntityId;
import org.apache.olingo.server.api.uri.UriInfoMetadata;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriInfoService;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceIt;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceRef;
import org.apache.olingo.server.api.uri.UriResourceRoot;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.DeltaTokenOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.IdOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;

public interface RequestURLVisitor {

  void visit(UriInfo info);

  void visit(UriInfoService info);

  void visit(UriInfoAll info);

  void visit(UriInfoBatch info);

  void visit(UriInfoCrossjoin info);

  void visit(UriInfoEntityId info);

  void visit(UriInfoMetadata info);

  void visit(UriInfoResource info);

  // Walk UriInfoResource
  void visit(ExpandOption option);

  void visit(FilterOption info);

  void visit(FormatOption info);

  void visit(IdOption info, EdmEntityType type);

  void visit(CountOption info);

  void visit(OrderByOption option);

  void visit(SearchOption option);

  void visit(SelectOption option);

  void visit(SkipOption option);

  void visit(SkipTokenOption option);

  void visit(TopOption option);

  void visit(UriResourceCount option);
  
  void visit(DeltaTokenOption option);
  
  void visit(UriResourceRef info);

  void visit(UriResourceRoot info);

  void visit(UriResourceValue info);

  void visit(UriResourceAction info);

  void visit(UriResourceEntitySet info);

  void visit(UriResourceFunction info);

  void visit(UriResourceIt info);

  void visit(UriResourceLambdaAll info);

  void visit(UriResourceLambdaAny info);

  void visit(UriResourceLambdaVariable info);

  void visit(UriResourceNavigation info);

  void visit(UriResourceSingleton info);

  void visit(UriResourceComplexProperty info);

  void visit(UriResourcePrimitiveProperty info);
}
