/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.filter;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.RangeTermFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.CollectionPropertyExpression;
import com.liferay.portal.odata.filter.expression.ComplexPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.LambdaVariableExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.PropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private final EntityModel _entityModel;
    private final Format _format;
    private final Locale _locale;

    public ExpressionVisitorImpl(Format format, Locale locale, EntityModel entityModel) {
        this._format = format;
        this._locale = locale;
        this._entityModel = entityModel;
    }

    public Filter visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        Optional<Filter> filterOptional = this._getFilterOptional(operation, left, right, this._locale);
        return filterOptional.orElseThrow(() -> new UnsupportedOperationException("Unsupported method visitBinaryExpressionOperation with operation " + operation));
    }

    public Object visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression) throws ExpressionVisitException {
        LambdaFunctionExpression lambdaFunctionExpression = collectionPropertyExpression.getLambdaFunctionExpression();
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return lambdaFunctionExpression.accept((ExpressionVisitor)new ExpressionVisitorImpl(this._format, this._locale, this._getLambdaEntityModel(lambdaFunctionExpression.getVariableName(), (CollectionEntityField)entityFieldsMap.get(collectionPropertyExpression.getName()))));
    }

    public Object visitComplexPropertyExpression(ComplexPropertyExpression complexPropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        ComplexEntityField complexEntityField = (ComplexEntityField)entityFieldsMap.get(complexPropertyExpression.getName());
        PropertyExpression propertyExpression = complexPropertyExpression.getPropertyExpression();
        Map complexEntityFieldEntityFieldsMap = complexEntityField.getEntityFieldsMap();
        return complexEntityFieldEntityFieldsMap.get(propertyExpression.getName());
    }

    public Object visitLambdaFunctionExpression(LambdaFunctionExpression.Type type, String variable, Expression expression) throws ExpressionVisitException {
        if (type == LambdaFunctionExpression.Type.ANY) {
            return this._any(expression);
        }
        throw new UnsupportedOperationException("Unsupported type visitLambdaFunctionExpression with type " + type);
    }

    public EntityField visitLambdaVariableExpression(LambdaVariableExpression lambdaVariableExpression) throws ExpressionVisitException {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        EntityField entityField = (EntityField)entityFieldsMap.get(lambdaVariableExpression.getVariableName());
        if (entityField == null) {
            throw new ExpressionVisitException("Invoked visitlambdavariableexpression when no entity field is stored for lambda variable name " + lambdaVariableExpression.getVariableName());
        }
        return entityField;
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        if (Objects.equals(LiteralExpression.Type.DATE, literalExpression.getType()) || Objects.equals(LiteralExpression.Type.DATE_TIME, literalExpression.getType())) {
            return this._normalizeDateLiteral(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType())) {
            return this._normalizeStringLiteral(literalExpression.getText());
        }
        return literalExpression.getText();
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        if (type == MethodExpression.Type.CONTAINS) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method", "type ", type, " and ", expressions.size(), "params"}));
            }
            return this._contains((EntityField)expressions.get(0), expressions.get(1), this._locale);
        }
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return entityFieldsMap.get(primitivePropertyExpression.getName());
    }

    public Filter visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        if (Objects.equals(UnaryExpression.Operation.NOT, operation)) {
            return this._getNotFilter((Filter)operand);
        }
        throw new UnsupportedOperationException("Unsupported method visitUnaryExpressionOperation with operation " + operation);
    }

    private Object _any(Expression expression) throws ExpressionVisitException {
        return expression.accept((ExpressionVisitor)this);
    }

    private Filter _contains(EntityField entityField, Object fieldValue, Locale locale) {
        return new QueryFilter((Query)new WildcardQueryImpl(entityField.getFilterableName(locale), "*" + entityField.getFilterableValue(fieldValue) + "*"));
    }

    private Filter _getANDFilter(Filter leftFilter, Filter rightFilter) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add(leftFilter, BooleanClauseOccur.MUST);
        booleanFilter.add(rightFilter, BooleanClauseOccur.MUST);
        return booleanFilter;
    }

    private Filter _getEQFilter(EntityField entityField, Object fieldValue, Locale locale) {
        return new TermFilter(entityField.getFilterableName(locale), entityField.getFilterableValue(fieldValue));
    }

    private Optional<Filter> _getFilterOptional(BinaryExpression.Operation operation, Object left, Object right, Locale locale) {
        Filter filter = null;
        if (Objects.equals(BinaryExpression.Operation.AND, operation)) {
            filter = this._getANDFilter((Filter)left, (Filter)right);
        } else if (Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            filter = this._getEQFilter((EntityField)left, right, locale);
        } else if (Objects.equals(BinaryExpression.Operation.GE, operation)) {
            filter = this._getGEFilter((EntityField)left, right, locale);
        } else if (Objects.equals(BinaryExpression.Operation.GT, operation)) {
            filter = this._getGTFilter((EntityField)left, right, locale);
        } else if (Objects.equals(BinaryExpression.Operation.LE, operation)) {
            filter = this._getLEFilter((EntityField)left, right, locale);
        } else if (Objects.equals(BinaryExpression.Operation.LT, operation)) {
            filter = this._getLTFilter((EntityField)left, right, locale);
        } else if (Objects.equals(BinaryExpression.Operation.OR, operation)) {
            filter = this._getORFilter((Filter)left, (Filter)right);
        } else {
            return Optional.empty();
        }
        return Optional.of(filter);
    }

    private Filter _getGEFilter(EntityField entityField, Object fieldValue, Locale locale) {
        if (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return new RangeTermFilter(entityField.getFilterableName(locale), true, true, entityField.getFilterableValue(fieldValue), null);
        }
        throw new UnsupportedOperationException("Unsupported method _getGEFilter with entity field type " + entityField.getType());
    }

    private Filter _getGTFilter(EntityField entityField, Object fieldValue, Locale locale) {
        if (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return new RangeTermFilter(entityField.getFilterableName(locale), false, true, entityField.getFilterableValue(fieldValue), null);
        }
        throw new UnsupportedOperationException("Unsupported method _getGTFilter with entity field type " + entityField.getType());
    }

    private EntityModel _getLambdaEntityModel(final String variableName, final CollectionEntityField collectionEntityField) {
        return new EntityModel(){

            public Map<String, EntityField> getEntityFieldsMap() {
                return Collections.singletonMap(variableName, collectionEntityField.getEntityField());
            }

            public String getName() {
                return collectionEntityField.getName();
            }
        };
    }

    private Filter _getLEFilter(EntityField entityField, Object fieldValue, Locale locale) {
        if (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return new RangeTermFilter(entityField.getFilterableName(locale), false, true, null, entityField.getFilterableValue(fieldValue));
        }
        throw new UnsupportedOperationException("Unsupported method _getLEFilter with entity field type " + entityField.getType());
    }

    private Filter _getLTFilter(EntityField entityField, Object fieldValue, Locale locale) {
        if (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return new RangeTermFilter(entityField.getFilterableName(locale), false, false, null, entityField.getFilterableValue(fieldValue));
        }
        throw new UnsupportedOperationException("Unsupported method _getLTFilter with entity field type " + entityField.getType());
    }

    private Filter _getNotFilter(Filter filter) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add(filter, BooleanClauseOccur.MUST_NOT);
        return booleanFilter;
    }

    private Filter _getORFilter(Filter leftFilter, Filter rightFilter) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add(leftFilter, BooleanClauseOccur.SHOULD);
        booleanFilter.add(rightFilter, BooleanClauseOccur.SHOULD);
        return booleanFilter;
    }

    private Object _normalizeDateLiteral(String literal) {
        try {
            Date date = ISO8601Utils.parse((String)literal, (ParsePosition)new ParsePosition(0));
            return this._format.format(date);
        }
        catch (ParseException pe) {
            throw new InvalidFilterException("Invalid date format, use ISO 8601: " + pe.getMessage());
        }
    }

    private Object _normalizeStringLiteral(String literal) {
        literal = StringUtil.toLowerCase((String)literal);
        literal = StringUtil.unquote((String)literal);
        return StringUtil.replace((String)literal, (String)"''", (String)"'");
    }
}

