/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.sort;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.odata.entity.EntityField;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;

public class SortField
implements Serializable {
    private final boolean _asc;
    private final EntityField _entityField;
    private final String _fieldName;
    private final List<EntityField> _parentEntityFields;

    public SortField(boolean asc, EntityField entityField, List<EntityField> parentEntityFields) {
        if (entityField == null) {
            throw new IllegalArgumentException("Entity field is null");
        }
        this._asc = asc;
        this._entityField = entityField;
        this._parentEntityFields = parentEntityFields;
        this._fieldName = entityField.getName();
    }

    public SortField(EntityField entityField, boolean asc) {
        this(asc, entityField, null);
    }

    public SortField(String fieldName, boolean asc) {
        this._fieldName = fieldName;
        this._asc = asc;
        this._entityField = null;
        this._parentEntityFields = null;
    }

    public String getSortableFieldName(Locale locale) {
        if (this._entityField == null) {
            return this._fieldName;
        }
        return this._entityField.getSortableName(locale);
    }

    public String getSortableFieldPath(Locale locale) {
        String sortableFieldName = this.getSortableFieldName(locale);
        if (ListUtil.isEmpty(this._parentEntityFields)) {
            return sortableFieldName;
        }
        String prefix = StringUtil.merge(this._parentEntityFields, parentEntityField -> parentEntityField.getSortableName(locale), (String)"/");
        return prefix + "/" + sortableFieldName;
    }

    public boolean isAscending() {
        return this._asc;
    }
}

