/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.entity;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityField;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface EntityModel {
    public static Map<String, EntityField> toEntityFieldsMap(EntityField ... entityFields) {
        HashMap<String, EntityField> entityFieldsMap = new HashMap<String, EntityField>();
        for (EntityField entityField : entityFields) {
            entityFieldsMap.put(entityField.getName(), entityField);
        }
        return entityFieldsMap;
    }

    public Map<String, EntityField> getEntityFieldsMap();

    default public Map<String, EntityRelationship> getEntityRelationshipsMap() {
        return Collections.emptyMap();
    }

    default public String getName() {
        Class<?> clazz = this.getClass();
        return StringUtil.replace((String)clazz.getName(), (char)'.', (char)'_');
    }

    public static class EntityRelationship {
        private final EntityModel _entityModel;
        private final String _name;
        private final Type _type;

        public EntityRelationship(EntityModel entityModel, String name, Type type) {
            this._entityModel = entityModel;
            this._name = name;
            this._type = type;
        }

        public EntityModel getEntityModel() {
            return this._entityModel;
        }

        public String getName() {
            return this._name;
        }

        public Type getType() {
            return this._type;
        }

        public static enum Type {
            COLLECTION,
            SINGLETON;

        }
    }
}

