/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.entity;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.odata.entity.EntityField;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComplexEntityField
extends EntityField {
    private final Map<String, EntityField> _entityFieldsMap;
    private final String _typeKey;

    public ComplexEntityField(String name, List<EntityField> entityFields) {
        this(name, entityFields, name);
    }

    public ComplexEntityField(String name, List<EntityField> entityFields, String typeKey) {
        super(name, EntityField.Type.COMPLEX, locale -> name, locale -> name, fieldValue -> String.valueOf(fieldValue));
        if (entityFields == null) {
            this._entityFieldsMap = Collections.emptyMap();
        } else {
            this._entityFieldsMap = new HashMap<String, EntityField>();
            for (EntityField entityField : entityFields) {
                this._entityFieldsMap.put(entityField.getName(), entityField);
            }
        }
        this._typeKey = typeKey;
    }

    public ComplexEntityField(String name, Map<String, EntityField> entityFieldsMap, String typeKey) {
        super(name, EntityField.Type.COMPLEX, locale -> name, locale -> name, fieldValue -> String.valueOf(fieldValue));
        this._entityFieldsMap = entityFieldsMap;
        this._typeKey = typeKey;
    }

    public Map<String, EntityField> getEntityFieldsMap() {
        return this._entityFieldsMap;
    }

    public String getTypeKey() {
        return this._typeKey;
    }

    @Override
    public String toString() {
        EntityField.Type type = this.getType();
        Map<String, EntityField> entityFieldsMap = this.getEntityFieldsMap();
        return StringBundler.concat((Object[])new Object[]{"{entityFields: ", entityFieldsMap.keySet(), ", name: ", this.getName(), ", type: ", type.name(), ", typeKey: ", this.getTypeKey(), "}"});
    }
}

