/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.entity;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.function.Function;

public class EntityField {
    private final Function<Locale, String> _filterableFieldNameFunction;
    private final Function<Object, String> _filterableFieldValueFunction;
    private final String _name;
    private final Function<Locale, String> _sortableFieldNameFunction;
    private final Type _type;

    public EntityField(String name, Type type, Function<Locale, String> sortableFieldNameFunction, Function<Locale, String> filterableFieldNameFunction, Function<Object, String> filterableFieldValueFunction) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException("Name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        if (sortableFieldNameFunction == null) {
            throw new IllegalArgumentException("Sortable field name function is null");
        }
        if (filterableFieldNameFunction == null) {
            throw new IllegalArgumentException("Filterable field name function is null");
        }
        if (filterableFieldValueFunction == null) {
            throw new IllegalArgumentException("Filterable field value function is null");
        }
        this._name = name;
        this._type = type;
        this._sortableFieldNameFunction = sortableFieldNameFunction;
        this._filterableFieldNameFunction = filterableFieldNameFunction;
        this._filterableFieldValueFunction = filterableFieldValueFunction;
    }

    public String getFilterableName(Locale locale) {
        return this._filterableFieldNameFunction.apply(locale);
    }

    public String getFilterableValue(Object fieldValue) {
        return this._filterableFieldValueFunction.apply(fieldValue);
    }

    public String getName() {
        return this._name;
    }

    public String getSortableName(Locale locale) {
        return this._sortableFieldNameFunction.apply(locale);
    }

    public Type getType() {
        return this._type;
    }

    public String toString() {
        return StringBundler.concat((String[])new String[]{"{name:", this._name, ", type:", this._type.name(), "}"});
    }

    public static enum Type {
        BOOLEAN,
        COLLECTION,
        COMPLEX,
        DATE,
        DATE_TIME,
        DOUBLE,
        ID,
        INTEGER,
        STRING;

    }
}

