/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.sort;

import com.liferay.portal.odata.entity.EntityField;
import java.io.Serializable;
import java.util.Locale;

public class SortField
implements Serializable {
    private final boolean _asc;
    private final EntityField _entityField;
    private final String _fieldName;

    public SortField(EntityField entityField, boolean asc) {
        if (entityField == null) {
            throw new IllegalArgumentException("Entity field is null");
        }
        this._entityField = entityField;
        this._asc = asc;
        this._fieldName = entityField.getName();
    }

    public SortField(String fieldName, boolean asc) {
        this._fieldName = fieldName;
        this._asc = asc;
        this._entityField = null;
    }

    public String getSortableFieldName(Locale locale) {
        if (this._entityField == null) {
            return this._fieldName;
        }
        return this._entityField.getSortableName(locale);
    }

    public boolean isAscending() {
        return this._asc;
    }
}

