/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.relationship.dynamic.data.mapping.internal;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.relationship.Relationship;
import com.liferay.portal.relationship.RelationshipResource;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure"}, service={RelationshipResource.class})
public class DDMStructureJournalRelationshipResource
implements RelationshipResource<DDMStructure> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;

    public Relationship<DDMStructure> relationship(Relationship.Builder<DDMStructure> builder) {
        return builder.modelSupplier(structureId -> this._ddmStructureLocalService.fetchStructure(structureId.longValue())).outboundMultiRelationship(this::_getStructureArticles).outboundMultiRelationship(this::_getStructureFolders).build();
    }

    private List<JournalArticle> _getStructureArticles(DDMStructure structure) {
        return this._journalArticleLocalService.getArticlesByStructureId(structure.getGroupId(), structure.getStructureKey(), -1, -1, null);
    }

    private List<JournalFolder> _getStructureFolders(DDMStructure structure) {
        List structureLinks = this._ddmStructureLinkLocalService.getStructureLinks(structure.getStructureId());
        Stream stream = structureLinks.stream();
        long classNameId = this._classNameLocalService.getClassNameId(JournalFolder.class);
        return stream.filter(structureLink -> structureLink.getClassNameId() == classNameId).map(structureLink -> this._journalFolderLocalService.fetchFolder(structureLink.getClassPK())).collect(Collectors.toList());
    }
}

