/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.relationship.document.library.internal;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.relationship.Relationship;
import com.liferay.portal.relationship.RelationshipResource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.document.library.kernel.model.DLFileEntryType"}, service={RelationshipResource.class})
public class DLFileEntryTypeDLRelationshipResource
implements RelationshipResource<DLFileEntryType> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryTypeDLRelationshipResource.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;

    public Relationship<DLFileEntryType> relationship(Relationship.Builder<DLFileEntryType> builder) {
        return builder.modelSupplier(fileEntryTypeId -> this._dlFileEntryTypeLocalService.fetchFileEntryType(fileEntryTypeId.longValue())).outboundSingleRelationship(this::_getFileEntry).outboundMultiRelationship(this::_getFolders).build();
    }

    private FileEntry _getFileEntry(DLFileEntryType fileEntryType) {
        List dlFileEntries = this._dlFileEntryLocalService.getFileEntries(-1, -1);
        Stream stream = dlFileEntries.parallelStream();
        return stream.filter(dlFileEntry -> dlFileEntry.getFileEntryTypeId() == fileEntryType.getFileEntryTypeId()).findFirst().map(dlFileEntry -> {
            try {
                return this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)pe.getMessage(), (Throwable)pe);
                }
                return null;
            }
        }).get();
    }

    private List<Folder> _getFolders(DLFileEntryType fileEntryType) {
        List dlFolders = this._dlFolderLocalService.getDLFileEntryTypeDLFolders(fileEntryType.getFileEntryTypeId());
        Stream stream = dlFolders.stream();
        return stream.map(dlFolder -> {
            try {
                return this._dlAppLocalService.getFolder(dlFolder.getFolderId());
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)pe.getMessage(), (Throwable)pe);
                }
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

