/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.recognition.internal.rule.group;

import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.rule.RuleGroupProcessor;
import com.liferay.mobile.device.rules.rule.RuleHandler;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleGroupLocalService;
import com.liferay.mobile.device.rules.util.comparator.RuleGroupInstancePriorityComparator;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={RuleGroupProcessor.class})
public class DefaultRuleGroupProcessorImpl
implements RuleGroupProcessor {
    private static final Log _log = LogFactoryUtil.getLog(DefaultRuleGroupProcessorImpl.class);
    private MDRRuleGroupInstanceLocalService _mdrRuleGroupInstanceLocalService;
    private MDRRuleGroupLocalService _mdrRuleGroupLocalService;
    private final Map<String, RuleHandler> _ruleHandlers = new HashMap<String, RuleHandler>();

    public MDRRuleGroupInstance evaluateRuleGroups(ThemeDisplay themeDisplay) {
        Layout layout = themeDisplay.getLayout();
        MDRRuleGroupInstance mdrRuleGroupInstance = this.evaluateRuleGroupInstances(Layout.class.getName(), layout.getPlid(), themeDisplay);
        if (mdrRuleGroupInstance != null) {
            return mdrRuleGroupInstance;
        }
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        mdrRuleGroupInstance = this.evaluateRuleGroupInstances(LayoutSet.class.getName(), layoutSet.getLayoutSetId(), themeDisplay);
        return mdrRuleGroupInstance;
    }

    public RuleHandler getRuleHandler(String ruleType) {
        return this._ruleHandlers.get(ruleType);
    }

    public Collection<RuleHandler> getRuleHandlers() {
        return Collections.unmodifiableCollection(this._ruleHandlers.values());
    }

    public Collection<String> getRuleHandlerTypes() {
        return this._ruleHandlers.keySet();
    }

    public void registerRuleHandler(RuleHandler ruleHandler) {
        this.addRuleHandler(ruleHandler);
    }

    public RuleHandler unregisterRuleHandler(String ruleType) {
        return this._ruleHandlers.remove(ruleType);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addRuleHandler(RuleHandler ruleHandler) {
        RuleHandler oldRuleHandler = this._ruleHandlers.put(ruleHandler.getType(), ruleHandler);
        if (oldRuleHandler != null && _log.isWarnEnabled()) {
            _log.warn((Object)("Replacing existing rule handler type " + ruleHandler.getType()));
        }
    }

    protected boolean evaluateRule(MDRRule rule, ThemeDisplay themeDisplay) {
        RuleHandler ruleHandler = this._ruleHandlers.get(rule.getType());
        if (ruleHandler != null) {
            return ruleHandler.evaluateRule(rule, themeDisplay);
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("No rule handler registered for type " + rule.getType()));
        }
        return false;
    }

    protected MDRRuleGroupInstance evaluateRuleGroupInstances(String className, long classPK, ThemeDisplay themeDisplay) {
        List mdrRuleGroupInstances = this._mdrRuleGroupInstanceLocalService.getRuleGroupInstances(className, classPK, -1, -1, (OrderByComparator)RuleGroupInstancePriorityComparator.INSTANCE_ASCENDING);
        for (MDRRuleGroupInstance mdrRuleGroupInstance : mdrRuleGroupInstances) {
            MDRRuleGroup mdrRuleGroup = this._mdrRuleGroupLocalService.fetchRuleGroup(mdrRuleGroupInstance.getRuleGroupId());
            if (mdrRuleGroup == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Rule group instance " + mdrRuleGroupInstance.getRuleGroupInstanceId() + " has invalid rule group"));
                continue;
            }
            List mdrRules = mdrRuleGroup.getRules();
            for (MDRRule mdrRule : mdrRules) {
                if (!this.evaluateRule(mdrRule, themeDisplay)) continue;
                return mdrRuleGroupInstance;
            }
        }
        return null;
    }

    protected void removeRuleHandler(RuleHandler ruleHandler) {
        this._ruleHandlers.remove(ruleHandler.getType());
    }

    @Reference(unbind="-")
    protected void setMdrRuleGroupInstanceLocalService(MDRRuleGroupInstanceLocalService mdrRuleGroupInstanceLocalService) {
        this._mdrRuleGroupInstanceLocalService = mdrRuleGroupInstanceLocalService;
    }

    @Reference(unbind="-")
    protected void setMdrRuleGroupLocalService(MDRRuleGroupLocalService mdrRuleGroupLocalService) {
        this._mdrRuleGroupLocalService = mdrRuleGroupLocalService;
    }
}

