/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.mobile.device.detection.fiftyonedegrees.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Brian Greenwald
 * @author Prathima Shreenath
 */
@ExtendedObjectClassDefinition(category = "devices")
@Meta.OCD(
	id = "com.liferay.portal.mobile.device.detection.fiftyonedegrees.configuration.FiftyOneDegreesConfiguration",
	localization = "content/Language",
	name = "51degrees-device-detection-configuration-name"
)
public interface FiftyOneDegreesConfiguration {

	@Meta.AD(deflt = "5000", name = "cache-size", required = false)
	public int cacheSize();

	@Meta.AD(
		deflt = "META-INF/51Degrees-LiteV3.2.dat",
		name = "fifty-one-degrees-data-file-name", required = false
	)
	public String fiftyOneDegreesDataFileName();

}