/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.lpkg.StaticLPKGResolver;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.lpkg.deployer.internal.wrapper.bundle.URLStreamHandlerServiceServiceTrackerCustomizer;
import com.liferay.portal.lpkg.deployer.internal.wrapper.bundle.WARBundleWrapperBundleActivator;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.service.url.URLConstants;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LPKGBundleTrackerCustomizer
implements BundleTrackerCustomizer<List<Bundle>> {
    private static final Log _log = LogFactoryUtil.getLog(LPKGBundleTrackerCustomizer.class);
    private final BundleContext _bundleContext;
    private final Map<String, URL> _urls;

    public LPKGBundleTrackerCustomizer(BundleContext bundleContext, Map<String, URL> urls) {
        this._bundleContext = bundleContext;
        this._urls = urls;
    }

    public List<Bundle> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        URL url = bundle.getEntry("liferay-marketplace.properties");
        if (url == null) {
            return null;
        }
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName.equals(StaticLPKGResolver.getStaticLPKGBundleSymbolicName())) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try {
            BundleStartLevel bundleStartLevel;
            Bundle newBundle;
            Enumeration enumeration = bundle.findEntries("/", "*.jar", false);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    url = (URL)enumeration.nextElement();
                    newBundle = this._bundleContext.installBundle(url.getPath(), url.openStream());
                    bundleStartLevel = (BundleStartLevel)newBundle.adapt(BundleStartLevel.class);
                    bundleStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL);
                    bundles.add(newBundle);
                }
            }
            if ((enumeration = bundle.findEntries("/", "*.war", false)) == null) {
                return bundles;
            }
            while (enumeration.hasMoreElements()) {
                url = (URL)enumeration.nextElement();
                newBundle = this._bundleContext.installBundle(url.getPath(), this._toWARWrapperBundle(bundle, url));
                bundleStartLevel = (BundleStartLevel)newBundle.adapt(BundleStartLevel.class);
                bundleStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL);
                bundles.add(newBundle);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Rollback bundle installation for " + bundles), (Throwable)e);
            for (Bundle newBundle : bundles) {
                try {
                    newBundle.uninstall();
                }
                catch (BundleException be) {
                    _log.error((Object)("Unable to uninstall bundle " + newBundle), (Throwable)be);
                }
            }
            return null;
        }
        return bundles;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<Bundle> bundles) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<Bundle> bundles) {
        if (bundle.getState() != 1) {
            return;
        }
        String lpkgBundleSymbolicName = bundle.getSymbolicName();
        String prefix = lpkgBundleSymbolicName.concat("-");
        for (Bundle newBundle : bundles) {
            try {
                newBundle.uninstall();
                String symbolicName = newBundle.getSymbolicName();
                if (!symbolicName.startsWith(prefix) || !symbolicName.endsWith("-wrapper")) continue;
                String wrappedBundleSymbolicName = symbolicName.substring(prefix.length(), symbolicName.length() - 8);
                Version version = newBundle.getVersion();
                for (Bundle curBundle : this._bundleContext.getBundles()) {
                    if (!wrappedBundleSymbolicName.equals(curBundle.getSymbolicName()) || !version.equals((Object)curBundle.getVersion())) continue;
                    curBundle.uninstall();
                }
            }
            catch (BundleException be) {
                _log.error((Object)("Unable to uninstall " + newBundle + " in response to uninstallation of " + bundle), (Throwable)be);
            }
        }
    }

    private String _buildImportPackageString(Class<?> ... classes) {
        StringBundler sb = new StringBundler(classes.length * 2);
        for (Class<?> clazz : classes) {
            Package pkg = clazz.getPackage();
            sb.append(pkg.getName());
            sb.append(",");
        }
        int index = sb.index();
        if (index > 0) {
            sb.setIndex(index - 1);
        }
        return sb.toString();
    }

    private InputStream _toWARWrapperBundle(Bundle bundle, URL url) throws IOException {
        String pathString = url.getPath();
        String contextName = pathString.substring(pathString.lastIndexOf(47) + 1, pathString.lastIndexOf(".war"));
        int index = contextName.lastIndexOf(45);
        if (index >= 0) {
            contextName = contextName.substring(0, index);
        }
        StringBundler sb = new StringBundler(7);
        sb.append("lpkg://");
        sb.append(bundle.getSymbolicName());
        sb.append("-");
        sb.append((Object)bundle.getVersion());
        sb.append("/");
        sb.append(contextName);
        sb.append(".war");
        String lpkgURL = sb.toString();
        this._urls.put(lpkgURL, url);
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                this._writeManifest(bundle, contextName, lpkgURL, jarOutputStream);
                this._writeClasses(jarOutputStream, WARBundleWrapperBundleActivator.class, URLStreamHandlerServiceServiceTrackerCustomizer.class);
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    private void _writeClasses(JarOutputStream jarOutputStream, Class<?> ... classes) throws IOException {
        for (Class<?> clazz : classes) {
            String className = clazz.getName();
            String path = StringUtil.replace((String)className, (char)'.', (char)'/');
            String resourcePath = path.concat(".class");
            jarOutputStream.putNextEntry(new ZipEntry(resourcePath));
            ClassLoader classLoader = clazz.getClassLoader();
            StreamUtil.transfer((InputStream)classLoader.getResourceAsStream(resourcePath), (OutputStream)jarOutputStream, (boolean)false);
            jarOutputStream.closeEntry();
        }
    }

    private void _writeManifest(Bundle bundle, String contextName, String lpkgURL, JarOutputStream jarOutputStream) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Bundle-Activator", WARBundleWrapperBundleActivator.class.getName());
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", bundle.getSymbolicName() + "-" + contextName + "-wrapper");
        Version version = bundle.getVersion();
        attributes.putValue("Bundle-Version", version.toString());
        attributes.putValue("Import-Package", this._buildImportPackageString(BundleActivator.class, BundleStartLevel.class, ServiceTrackerCustomizer.class, URLConstants.class));
        attributes.putValue("Liferay-WAB-Context-Name", contextName);
        attributes.putValue("Liferay-WAB-LPKG-URL", lpkgURL);
        attributes.putValue("Liferay-WAB-Start-Level", String.valueOf(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL));
        attributes.putValue("Manifest-Version", "2");
        jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(jarOutputStream);
        jarOutputStream.closeEntry();
    }
}

