/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import com.liferay.portal.lpkg.deployer.LPKGVerifier;
import com.liferay.portal.lpkg.deployer.LPKGVerifyException;
import com.liferay.portal.lpkg.deployer.internal.LPKGBundleTrackerCustomizer;
import com.liferay.portal.lpkg.deployer.internal.LPKGIndexValidator;
import com.liferay.portal.lpkg.deployer.internal.LPKGIndexValidatorThreadLocal;
import com.liferay.portal.lpkg.deployer.internal.LPKGURLStreamHandlerService;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={LPKGDeployer.class})
public class DefaultLPKGDeployer
implements LPKGDeployer {
    private static final Log _log = LogFactoryUtil.getLog(DefaultLPKGDeployer.class);
    private Path _deploymentDirPath;
    private BundleTracker<List<Bundle>> _lpkgBundleTracker;
    @Reference
    private LPKGIndexValidator _lpkgIndexValidator;
    @Reference
    private LPKGVerifier _lpkgVerifier;
    @Reference(target="(throwable.collector=initial.bundles)")
    private ThrowableCollector _throwableCollector;
    private final Map<String, URL> _urls = new ConcurrentHashMap<String, URL>();

    @Activate
    public void activate(BundleContext bundleContext) {
        try {
            this._doActivate(bundleContext);
        }
        catch (Throwable t) {
            this._throwableCollector.collect(t);
        }
    }

    @Override
    public List<Bundle> deploy(BundleContext bundleContext, File lpkgFile) throws IOException {
        Path lpkgFilePath = lpkgFile.toPath();
        if (!lpkgFilePath.startsWith(this._deploymentDirPath)) {
            throw new LPKGVerifyException("Unable to deploy " + lpkgFile + " from outside the deployment directory " + this._deploymentDirPath);
        }
        for (Bundle bundle : this._lpkgVerifier.verify(lpkgFile)) {
            try {
                String location;
                bundle.uninstall();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Uninstalled older LPKG bundle " + bundle + " in order to install " + lpkgFile));
                }
                if ((location = bundle.getLocation()).equals(lpkgFile.getCanonicalPath()) || !Files.deleteIfExists(Paths.get(bundle.getLocation(), new String[0])) || !_log.isInfoEnabled()) continue;
                _log.info((Object)("Removed old LPKG bundle " + bundle.getLocation()));
            }
            catch (BundleException be) {
                _log.error((Object)("Unable to uninstall " + bundle + " in order to install " + lpkgFile), (Throwable)be);
            }
        }
        try {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            Bundle lpkgBundle = bundleContext.installBundle(lpkgFile.getCanonicalPath(), this.toBundle(lpkgFile));
            BundleStartLevel bundleStartLevel = (BundleStartLevel)lpkgBundle.adapt(BundleStartLevel.class);
            bundleStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL);
            bundles.add(lpkgBundle);
            List newBundles = (List)this._lpkgBundleTracker.getObject(lpkgBundle);
            if (newBundles != null) {
                bundles.addAll(newBundles);
            }
            if (LPKGIndexValidatorThreadLocal.isEnabled()) {
                this._lpkgIndexValidator.updateIntegrityProperties();
            }
            return bundles;
        }
        catch (BundleException be) {
            throw new IOException(be);
        }
    }

    @Override
    public Map<Bundle, List<Bundle>> getDeployedLPKGBundles() {
        return this._lpkgBundleTracker.getTracked();
    }

    @Override
    public InputStream toBundle(File lpkgFile) throws IOException {
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (ZipFile zipFile = new ZipFile(lpkgFile);
                 JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                this._writeManifest(zipFile, jarOutputStream);
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    jarOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    StreamUtil.transfer((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)jarOutputStream, (boolean)false);
                    jarOutputStream.closeEntry();
                }
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    @Deactivate
    protected void deactivate() {
        this._lpkgBundleTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _doActivate(BundleContext bundleContext) throws Exception {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("url.handler.protocol", new String[]{"lpkg"});
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new LPKGURLStreamHandlerService(this._urls), (Dictionary)properties);
        this._lpkgBundleTracker = new BundleTracker(bundleContext, -2, (BundleTrackerCustomizer)new LPKGBundleTrackerCustomizer(bundleContext, this._urls));
        this._lpkgBundleTracker.open();
        String deploymentDir = GetterUtil.getString((String)bundleContext.getProperty("lpkg.deployer.dir"), (String)(PropsValues.MODULE_FRAMEWORK_BASE_DIR + "/marketplace"));
        this._deploymentDirPath = Paths.get(deploymentDir, new String[0]);
        Files.createDirectories(this._deploymentDirPath, new FileAttribute[0]);
        final ArrayList<File> lpkgFiles = new ArrayList<File>();
        Files.walkFileTree(this._deploymentDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                Path fileNamePath = filePath.getFileName();
                String fileName = StringUtil.toLowerCase((String)fileNamePath.toString());
                if (!fileName.endsWith(".lpkg")) {
                    return FileVisitResult.CONTINUE;
                }
                lpkgFiles.add(filePath.toFile());
                return FileVisitResult.CONTINUE;
            }
        });
        this._lpkgIndexValidator.setLPKGDeployer(this);
        boolean updateIntegrityProperties = this._lpkgIndexValidator.validate(lpkgFiles);
        boolean enabled = LPKGIndexValidatorThreadLocal.isEnabled();
        LPKGIndexValidatorThreadLocal.setEnabled(false);
        try {
            for (File lpkgFile : lpkgFiles) {
                try {
                    List<Bundle> bundles = this.deploy(bundleContext, lpkgFile);
                    for (Bundle bundle : bundles) {
                        Dictionary headers = bundle.getHeaders();
                        String fragmentHost = (String)headers.get("Fragment-Host");
                        if (fragmentHost != null) continue;
                        try {
                            bundle.start();
                        }
                        catch (BundleException be) {
                            _log.error((Object)("Unable to start " + bundle + " for " + lpkgFile), (Throwable)be);
                        }
                    }
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to deploy LPKG file " + lpkgFile), (Throwable)e);
                }
            }
            if (updateIntegrityProperties) {
                this._lpkgIndexValidator.updateIntegrityProperties();
            }
        }
        finally {
            LPKGIndexValidatorThreadLocal.setEnabled(enabled);
        }
    }

    private void _writeManifest(ZipFile zipFile, JarOutputStream jarOutputStream) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(zipFile.getEntry("liferay-marketplace.properties")));
        attributes.putValue("Bundle-Description", properties.getProperty("description"));
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", properties.getProperty("title"));
        attributes.putValue("Bundle-Version", properties.getProperty("version"));
        attributes.putValue("Liferay-Releng-Bundle-Type", "lpkg");
        attributes.putValue("Manifest-Version", "2");
        jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(jarOutputStream);
        jarOutputStream.closeEntry();
    }
}

