/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.test.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Version;

public class LPKGTestUtil {
    private static final Version _DEFAULT_VERSION = new Version(1, 0, 0);

    public static InputStream createJAR(String symbolicName) throws IOException {
        return LPKGTestUtil.createJAR(symbolicName, _DEFAULT_VERSION);
    }

    public static InputStream createJAR(String symbolicName, Version version) throws IOException {
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                Manifest manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.putValue("Bundle-ManifestVersion", "2");
                attributes.putValue("Bundle-SymbolicName", symbolicName);
                attributes.putValue("Bundle-Version", version.toString());
                attributes.putValue("Manifest-Version", "2");
                jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(jarOutputStream);
                jarOutputStream.closeEntry();
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    public static void createLPKG(Path path, String symbolicName, boolean createWar) throws IOException {
        LPKGTestUtil.createLPKG(path, symbolicName, createWar, _DEFAULT_VERSION, _DEFAULT_VERSION);
    }

    public static void createLPKG(Path path, String symbolicName, boolean createWar, Version lpkgVersion, Version jarVersion) throws IOException {
        block61: {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(path.toFile()));){
                Throwable throwable;
                OutputStream outputStream;
                zipOutputStream.putNextEntry(new ZipEntry("liferay-marketplace.properties"));
                StringBundler sb = new StringBundler(16);
                sb.append("bundles=");
                sb.append(symbolicName);
                sb.append("#");
                sb.append(jarVersion.toString());
                sb.append("##\n");
                sb.append("category=Test\n");
                sb.append("context-names=\n");
                sb.append("description=Test\n");
                sb.append("icon-url=https://www.liferay.com/web/guest/marketplace");
                sb.append("/-/mp/asset/icon/71985553\n");
                sb.append("remote-app-id=Test\n");
                sb.append("restart-required=false\n");
                sb.append("title=");
                String name = String.valueOf(path.getFileName());
                sb.append(name.substring(0, name.indexOf(".lpkg")));
                sb.append("\nversion=");
                sb.append(lpkgVersion.toString());
                String properties = sb.toString();
                zipOutputStream.write(properties.getBytes());
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(StringBundler.concat((String[])new String[]{symbolicName, "-", jarVersion.toString(), ".jar"})));
                try (InputStream inputStream = LPKGTestUtil.createJAR(symbolicName, jarVersion);){
                    outputStream = StreamUtil.uncloseable((OutputStream)zipOutputStream);
                    throwable = null;
                    try {
                        StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                    }
                }
                zipOutputStream.closeEntry();
                if (!createWar) break block61;
                zipOutputStream.putNextEntry(new ZipEntry(symbolicName.concat("-war-1.0.0.war")));
                inputStream = LPKGTestUtil.createWAR(symbolicName);
                var11_13 = null;
                try {
                    outputStream = StreamUtil.uncloseable((OutputStream)zipOutputStream);
                    throwable = null;
                    try {
                        StreamUtil.transfer((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    var11_13 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (inputStream != null) {
                        if (var11_13 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable7) {
                                var11_13.addSuppressed(throwable7);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
        }
    }

    public static InputStream createWAR(String symbolicName) throws IOException {
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                jarOutputStream.putNextEntry(new ZipEntry("WEB-INF/liferay-plugin-package.properties"));
                StringBundler sb = new StringBundler(12);
                sb.append("author=Liferay, Inc.\n");
                sb.append("change-log=\n");
                sb.append("licenses=LGPL\n");
                sb.append("liferay-versions=7.0.1+\n");
                sb.append("long-description=\n");
                sb.append("module-group-id=liferay\n");
                sb.append("module-incremental-version=1\n");
                sb.append("page-url=http://www.liferay.com\n");
                sb.append("module-version=1.0.20\n");
                sb.append("name=");
                sb.append(symbolicName);
                sb.append("-war");
                String properties = sb.toString();
                jarOutputStream.write(properties.getBytes());
                jarOutputStream.closeEntry();
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }
}

