/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.BundleContext;

public class ContainerLPKGUtil {
    public static List<File> deploy(File lpkgFile, BundleContext bundleContext, Properties properties) throws IOException {
        Path deployerDirPath = Paths.get(GetterUtil.getString((String)bundleContext.getProperty("lpkg.deployer.dir"), (String)PropsValues.MODULE_FRAMEWORK_MARKETPLACE_DIR), new String[0]);
        ArrayList<File> lpkgFiles = new ArrayList<File>();
        try (ZipFile zipFile = new ZipFile(lpkgFile);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.endsWith(".lpkg")) {
                    InputStream inputStream;
                    if (properties != null && (zipEntry = zipFile.getEntry("liferay-marketplace.properties")) != null) {
                        inputStream = zipFile.getInputStream(zipEntry);
                        Throwable throwable = null;
                        try {
                            properties.load(inputStream);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                        }
                    }
                    inputStream = null;
                    return inputStream;
                }
                Path lpkgPath = deployerDirPath.resolve(name);
                Files.copy(zipFile.getInputStream(zipEntry), lpkgPath, StandardCopyOption.REPLACE_EXISTING);
                lpkgFiles.add(lpkgPath.toFile());
            }
        }
        if (lpkgFiles.isEmpty()) {
            return null;
        }
        lpkgFile.delete();
        return lpkgFiles;
    }
}

