/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lpkg.deployer.LPKGVerifier;
import com.liferay.portal.lpkg.deployer.LPKGVerifyException;
import com.liferay.portal.lpkg.deployer.internal.LPKGLocationUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={LPKGVerifier.class})
public class DefaultLPKGVerifier
implements LPKGVerifier {
    private BundleContext _bundleContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Bundle> verify(File lpkgFile) {
        try (ZipFile zipFile = new ZipFile(lpkgFile);){
            ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
            if (zipEntry == null) {
                throw new LPKGVerifyException(lpkgFile + " does not have liferay-marketplace.properties");
            }
            Properties properties = new Properties();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                properties.load(inputStream);
            }
            String symbolicName = lpkgFile.getName();
            symbolicName = symbolicName.substring(0, symbolicName.length() - 5);
            if (Validator.isNull((String)symbolicName)) {
                throw new LPKGVerifyException(lpkgFile + " does not have a valid symbolic name");
            }
            Version version = null;
            String versionString = properties.getProperty("version");
            try {
                version = new Version(versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new LPKGVerifyException(lpkgFile + " does not have a valid version: " + versionString, (Throwable)illegalArgumentException);
            }
            ArrayList<Bundle> oldBundles = new ArrayList<Bundle>();
            for (Bundle bundle : this._bundleContext.getBundles()) {
                if (!symbolicName.equals(bundle.getSymbolicName())) continue;
                int value = version.compareTo(bundle.getVersion());
                if (value != 0) {
                    oldBundles.add(bundle);
                    continue;
                }
                String location = LPKGLocationUtil.getLPKGLocation(lpkgFile);
                if (location.equals(bundle.getLocation())) continue;
                throw new LPKGVerifyException(StringBundler.concat((Object[])new Object[]{"Existing LPKG bundle ", bundle, " has the same symbolic name and version as LPKG ", "file ", location}));
            }
            ArrayList<Bundle> arrayList = oldBundles;
            return arrayList;
        }
        catch (Exception exception) {
            throw new LPKGVerifyException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }
}

