/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.URLCodec;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(immediate=true, service={BytesURLProtocolSupport.class})
public class BytesURLProtocolSupport {
    private final Map<URL, byte[]> _bytesMap = new ConcurrentHashMap<URL, byte[]>();

    public URL putBytes(String id, byte[] bytes) {
        try {
            URL url = new URL("bytes://localhost/".concat(URLCodec.encodeURL((String)id)));
            this._bytesMap.put(url, bytes);
            return url;
        }
        catch (MalformedURLException malformedURLException) {
            return (URL)ReflectionUtil.throwException((Throwable)malformedURLException);
        }
    }

    public byte[] removeBytes(URL url) {
        return this._bytesMap.remove(url);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("url.handler.protocol", new String[]{"bytes"});
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new BytesURLStreamHandlerService(), (Dictionary)properties);
    }

    private class BytesURLStreamHandlerService
    extends AbstractURLStreamHandlerService {
        private BytesURLStreamHandlerService() {
        }

        public URLConnection openConnection(URL url) {
            return new BytesURLConnection(url);
        }
    }

    private class BytesURLConnection
    extends URLConnection {
        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            byte[] bytes = (byte[])BytesURLProtocolSupport.this._bytesMap.get(this.url);
            if (bytes == null) {
                throw new IOException("Unable to get bytes for URL " + this.url);
            }
            return new UnsyncByteArrayInputStream(bytes);
        }

        private BytesURLConnection(URL url) {
            super(url);
        }
    }
}

