/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessConfig;
import com.liferay.petra.process.local.LocalProcessExecutor;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import com.liferay.portal.lpkg.deployer.LPKGVerifyException;
import com.liferay.portal.lpkg.deployer.internal.BytesURLProtocolSupport;
import com.liferay.portal.lpkg.deployer.internal.TargetPlatformIndexerProcessCallable;
import com.liferay.portal.target.platform.indexer.IndexValidator;
import com.liferay.portal.target.platform.indexer.IndexValidatorFactory;
import com.liferay.portal.target.platform.indexer.Indexer;
import com.liferay.portal.target.platform.indexer.IndexerFactory;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LPKGIndexValidator.class})
public class LPKGIndexValidator {
    private static final Log _log = LogFactoryUtil.getLog(LPKGIndexValidator.class);
    private static final Pattern _incrementPattern = Pattern.compile("<repository( increment=\"\\d*\")");
    @Reference
    private BytesURLProtocolSupport _bytesURLProtocolSupport;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private boolean _enabled;
    @Reference
    private IndexerFactory _indexerFactory;
    @Reference
    private IndexValidatorFactory _indexValidatorFactory;
    private final Path _integrityPropertiesFilePath = Paths.get(PropsValues.MODULE_FRAMEWORK_BASE_DIR, "target-platform", "integrity.properties");
    private Set<String> _jarFileNames;
    private List<File> _jarFiles;
    private LPKGDeployer _lpkgDeployer;
    private ProcessConfig _processConfig;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._enabled = GetterUtil.getBoolean((String)bundleContext.getProperty("lpkg.index.validator.enabled"), (boolean)true);
        this._processConfig = PortalClassPathUtil.createProcessConfig((Class[])new Class[]{IndexerFactory.class, this._indexerFactory.getClass(), Bundle.class, TargetPlatformIndexerProcessCallable.class});
    }

    public boolean checkIntegrity(List<URI> indexURIs) {
        if (Files.notExists(this._integrityPropertiesFilePath, new LinkOption[0])) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Skip integrity check because " + this._integrityPropertiesFilePath + " does not exist"));
            }
            return false;
        }
        Properties properties = new Properties();
        try {
            InputStream inputStream = Files.newInputStream(this._integrityPropertiesFilePath, new OpenOption[0]);
            Iterator<URI> iterator = null;
            try {
                properties.load(inputStream);
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (iterator != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to read " + this._integrityPropertiesFilePath), (Throwable)ioe);
            return false;
        }
        HashSet<String> integrityKeys = new HashSet<String>();
        for (URI uri : indexURIs) {
            integrityKeys.add(this._toIntegrityKey(uri));
        }
        if (!integrityKeys.equals(properties.stringPropertyNames())) {
            if (_log.isInfoEnabled()) {
                ArrayList<String> expectedKeys = new ArrayList<String>(properties.stringPropertyNames());
                Collections.sort(expectedKeys);
                ArrayList actualKeys = new ArrayList(integrityKeys);
                Collections.sort(actualKeys);
                _log.info((Object)StringBundler.concat((String[])new String[]{"Running validation because expected keys: ", String.valueOf(expectedKeys), " do not match actual keys: ", String.valueOf(actualKeys)}));
            }
            return false;
        }
        for (URI uri : indexURIs) {
            String integrityKey = this._toIntegrityKey(uri);
            try {
                String actualChecksum;
                String expectedChecksum = properties.getProperty(integrityKey);
                if (Objects.equals(expectedChecksum, actualChecksum = this._toChecksum(uri))) continue;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Running validation because of mismatched checksum for " + integrityKey));
                }
                return false;
            }
            catch (Exception e) {
                _log.error((Object)("Unable to generate checksum for " + uri));
                return false;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Passed integrity check");
        }
        return true;
    }

    public void setJarFiles(List<File> jarFiles) {
        this._jarFiles = jarFiles;
        HashSet<String> jarFileNames = new HashSet<String>();
        for (File file : jarFiles) {
            jarFileNames.add(StringUtil.toLowerCase((String)file.getName()));
        }
        this._jarFileNames = jarFileNames;
    }

    public void setLPKGDeployer(LPKGDeployer lpkgDeployer) {
        this._lpkgDeployer = lpkgDeployer;
    }

    public void updateIntegrityProperties() {
        try {
            List<URI> indexURIs = this._getTargetPlatformIndexURIs();
            Collections.sort(indexURIs);
            StringBundler sb = new StringBundler(indexURIs.size() * 4);
            for (URI uri : indexURIs) {
                sb.append(this._toIntegrityKey(uri));
                sb.append("=");
                sb.append(this._toChecksum(uri));
                sb.append("\n");
            }
            sb.setIndex(sb.index() - 1);
            Files.createDirectories(this._integrityPropertiesFilePath.getParent(), new FileAttribute[0]);
            Files.write(this._integrityPropertiesFilePath, Collections.singleton(sb.toString()), StandardCharsets.UTF_8, new OpenOption[0]);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Updated " + this._integrityPropertiesFilePath));
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to update integrity properties", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(List<File> lpkgFiles) throws Exception {
        List<URI> lpkgIndexURIs;
        List<URI> targetPlatformIndexURIs;
        long start;
        block7: {
            if (!this._enabled) {
                return false;
            }
            start = System.currentTimeMillis();
            ArrayList<URI> allIndexURIs = new ArrayList<URI>();
            targetPlatformIndexURIs = this._getTargetPlatformIndexURIs();
            allIndexURIs.addAll(targetPlatformIndexURIs);
            lpkgIndexURIs = this._indexLPKGFiles(lpkgFiles);
            allIndexURIs.addAll(lpkgIndexURIs);
            if (this.checkIntegrity(allIndexURIs)) {
                return false;
            }
            IndexValidator indexValidator = this._indexValidatorFactory.create(targetPlatformIndexURIs);
            try {
                List messages = indexValidator.validate(lpkgIndexURIs);
                if (messages.isEmpty()) break block7;
                StringBundler sb = new StringBundler(messages.size() * 3 + 1);
                sb.append("LPKG validation failed with {");
                for (String message : messages) {
                    sb.append("[");
                    sb.append(message);
                    sb.append("], ");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("]}");
                throw new LPKGVerifyException(sb.toString());
            }
            catch (Throwable throwable) {
                this._cleanUp(targetPlatformIndexURIs);
                this._cleanUp(lpkgIndexURIs);
                if (_log.isInfoEnabled()) {
                    long duration = System.currentTimeMillis() - start;
                    _log.info((Object)String.format("LPKG validation time %02d:%02ds", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration % 60000L)));
                }
                throw throwable;
            }
        }
        this._cleanUp(targetPlatformIndexURIs);
        this._cleanUp(lpkgIndexURIs);
        if (_log.isInfoEnabled()) {
            long duration = System.currentTimeMillis() - start;
            _log.info((Object)String.format("LPKG validation time %02d:%02ds", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration % 60000L)));
        }
        return true;
    }

    private void _cleanUp(List<URI> uris) throws MalformedURLException {
        for (URI uri : uris) {
            this._bytesURLProtocolSupport.removeBytes(uri.toURL());
        }
    }

    private List<URI> _getTargetPlatformIndexURIs() throws Exception {
        File file;
        ArrayList<File> files = new ArrayList<File>();
        Map deployedLPKGBundles = this._lpkgDeployer.getDeployedLPKGBundles();
        for (Bundle bundle : deployedLPKGBundles.keySet()) {
            files.add(new File(bundle.getLocation()));
        }
        List<URI> uris = this._indexLPKGFiles(files);
        LocalProcessExecutor localProcessExecutor = new LocalProcessExecutor();
        ArrayList<File> additionalJarFiles = new ArrayList<File>(this._jarFiles);
        additionalJarFiles.add(new File(PropsValues.LIFERAY_LIB_PORTAL_DIR, "util-taglib.jar"));
        Configuration configuration = this._configurationAdmin.getConfiguration("com.liferay.modules.compat.internal.configuration.ModuleCompatExtenderConfiguration", "?");
        Dictionary properties = configuration.getProperties();
        boolean enabled = true;
        if (properties != null) {
            enabled = Boolean.valueOf((String)properties.get("enabled"));
        }
        if (enabled && (file = new File(PropsValues.MODULE_FRAMEWORK_BASE_DIR, "compat/com.liferay.modules.compat.data.jar")).exists()) {
            additionalJarFiles.add(file);
        }
        ProcessChannel processChannel = localProcessExecutor.execute(this._processConfig, (ProcessCallable)new TargetPlatformIndexerProcessCallable(additionalJarFiles, PropsValues.MODULE_FRAMEWORK_STOP_WAIT_TIMEOUT, PropsValues.MODULE_FRAMEWORK_BASE_DIR + "/static", PropsValues.MODULE_FRAMEWORK_MODULES_DIR, PropsValues.MODULE_FRAMEWORK_PORTAL_DIR));
        NoticeableFuture future = processChannel.getProcessNoticeableFuture();
        URL url = this._bytesURLProtocolSupport.putBytes("liferay-target-platform", (byte[])future.get());
        uris.add(url.toURI());
        return uris;
    }

    private List<URI> _indexLPKGFiles(List<File> lpkgFiles) throws Exception {
        ArrayList<URI> uris = new ArrayList<URI>();
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try {
            for (File lpkgFile : lpkgFiles) {
                Indexer indexer = this._indexerFactory.createLPKGIndexer(lpkgFile, this._jarFileNames);
                indexer.index((OutputStream)unsyncByteArrayOutputStream);
                String name = lpkgFile.getName();
                URL url = this._bytesURLProtocolSupport.putBytes(name.substring(0, name.length() - 5), unsyncByteArrayOutputStream.toByteArray());
                unsyncByteArrayOutputStream.reset();
                uris.add(url.toURI());
            }
        }
        catch (Exception e) {
            this._cleanUp(uris);
            throw e;
        }
        return uris;
    }

    private String _toChecksum(URI uri) throws Exception {
        URL url = uri.toURL();
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)url.openStream(), (OutputStream)unsyncByteArrayOutputStream);
        String content = unsyncByteArrayOutputStream.toString("UTF-8");
        Matcher matcher = _incrementPattern.matcher(content);
        if (matcher.find()) {
            String start = content.substring(0, matcher.start(1));
            String end = content.substring(matcher.end(1));
            content = start.concat(end);
        }
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(content.getBytes(StandardCharsets.UTF_8));
        return StringUtil.bytesToHexString((byte[])messageDigest.digest());
    }

    private String _toIntegrityKey(URI uri) {
        String integrityKey = uri.getPath();
        int index = integrityKey.lastIndexOf("/");
        if (index != -1) {
            integrityKey = integrityKey.substring(index + 1);
        }
        return integrityKey;
    }
}

