/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.URLStreamHandlerService;

@Component(immediate=true)
public class LPKGArtifactInstaller
implements ArtifactInstaller {
    private static final Log _log = LogFactoryUtil.getLog(LPKGArtifactInstaller.class);
    private BundleContext _bundleContext;
    @Reference
    private LPKGDeployer _lpkgDeployer;
    @Reference(target="(url.handler.protocol=webbundle)")
    private URLStreamHandlerService _urlStreamHandlerService;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public boolean canHandle(File file) {
        String name = StringUtil.toLowerCase((String)file.getName());
        return name.endsWith(".lpkg");
    }

    public void install(File file) throws Exception {
        Properties properties;
        if (this._isLPKGContainer(file)) {
            Path deployerDirPath = Paths.get(GetterUtil.getString((String)this._bundleContext.getProperty("lpkg.deployer.dir"), (String)PropsValues.MODULE_FRAMEWORK_MARKETPLACE_DIR), new String[0]);
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    Files.copy(zipFile.getInputStream(zipEntry), deployerDirPath.resolve(zipEntry.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            file.delete();
            return;
        }
        Bundle existingBundle = this._bundleContext.getBundle(file.getCanonicalPath());
        if (existingBundle != null) {
            this.update(file);
        }
        if (GetterUtil.getBoolean((String)(properties = this._readMarketplaceProperties(file)).getProperty("restart-required"), (boolean)true)) {
            if (existingBundle == null) {
                this._logRestartRequired(file.getCanonicalPath());
            }
            return;
        }
        for (Bundle bundle : this._lpkgDeployer.deploy(this._bundleContext, file)) {
            Dictionary headers = bundle.getHeaders("");
            String fragmentHost = (String)headers.get("Fragment-Host");
            if (fragmentHost != null) continue;
            try {
                bundle.start();
            }
            catch (BundleException be) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to start ", String.valueOf(bundle), " for ", String.valueOf(file)}), (Throwable)be);
            }
        }
    }

    public void uninstall(File file) throws Exception {
        Bundle bundle = this._bundleContext.getBundle(file.getCanonicalPath());
        if (bundle != null) {
            bundle.uninstall();
        }
    }

    public void update(File file) throws Exception {
        Properties properties = this._readMarketplaceProperties(file);
        String canonicalPath = file.getCanonicalPath();
        Bundle bundle = this._bundleContext.getBundle(canonicalPath);
        if (bundle != null) {
            Version currentVersion = bundle.getVersion();
            Version newVersion = new Version(properties.getProperty("version"));
            if (newVersion.compareTo(currentVersion) > 0) {
                if (GetterUtil.getBoolean((String)properties.getProperty("restart-required"), (boolean)true)) {
                    this._logRestartRequired(canonicalPath);
                    return;
                }
                Map deployedLPKGBundles = this._lpkgDeployer.getDeployedLPKGBundles();
                List installedBundles = (List)deployedLPKGBundles.get(bundle);
                HashSet<Bundle> wrapperBundles = new HashSet<Bundle>();
                for (Bundle installedBundle : installedBundles) {
                    Dictionary headers = bundle.getHeaders("");
                    if (!Boolean.getBoolean((String)headers.get("Wrapper-Bundle"))) continue;
                    wrapperBundles.add(installedBundle);
                }
                if (!wrapperBundles.isEmpty()) {
                    FrameworkEvent frameworkEvent;
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((String[])new String[]{"Refreshing ", String.valueOf(wrapperBundles), " to update ", String.valueOf(bundle)}));
                    }
                    if ((frameworkEvent = this._refreshBundles(wrapperBundles)).getType() != 4) {
                        _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to refresh ", String.valueOf(wrapperBundles), " because of framework event ", String.valueOf(frameworkEvent)}), frameworkEvent.getThrowable());
                    }
                }
                bundle.update(this._lpkgDeployer.toBundle(file));
            }
        }
    }

    private boolean _isLPKGContainer(File file) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String name = zipEntry.getName();
                if (name.endsWith(".lpkg")) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void _logRestartRequired(String canonicalPath) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("The portal instance needs to be restarted to complete the installation of " + canonicalPath));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties _readMarketplaceProperties(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
            if (zipEntry == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties properties3 = new Properties();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                properties3.load(inputStream);
            }
            Properties properties = properties3;
            return properties;
        }
        catch (Exception e) {
            if (!_log.isDebugEnabled()) return null;
            _log.debug((Object)("Unable to read liferay-marketplace.properties from " + file.getName()), (Throwable)e);
            return null;
        }
    }

    private FrameworkEvent _refreshBundles(Set<Bundle> bundles) throws Exception {
        Bundle systemBundle = this._bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        return (FrameworkEvent)defaultNoticeableFuture.get();
    }
}

