/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ThrowableCollector;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import com.liferay.portal.lpkg.deployer.LPKGVerifier;
import com.liferay.portal.lpkg.deployer.LPKGVerifyException;
import com.liferay.portal.lpkg.deployer.internal.LPKGBundleTrackerCustomizer;
import com.liferay.portal.lpkg.deployer.internal.LPKGIndexValidator;
import com.liferay.portal.lpkg.deployer.internal.LPKGIndexValidatorThreadLocal;
import com.liferay.portal.lpkg.deployer.internal.LPKGURLStreamHandlerService;
import com.liferay.portal.lpkg.deployer.internal.WABWrapperBundleTrackerCustomizer;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={LPKGDeployer.class})
public class DefaultLPKGDeployer
implements LPKGDeployer {
    private static final String _LPKG_OVERRIDE_PREFIX = "LPKG-Override::";
    private static final Log _log = LogFactoryUtil.getLog(DefaultLPKGDeployer.class);
    private static final Pattern _pattern = Pattern.compile("/?(.*?)(-\\d+\\.\\d+\\.\\d+)(\\..+)?(\\.[jw]ar)");
    private Path _deploymentDirPath;
    private BundleTracker<List<Bundle>> _lpkgBundleTracker;
    @Reference
    private LPKGIndexValidator _lpkgIndexValidator;
    @Reference
    private LPKGVerifier _lpkgVerifier;
    @Reference(target="(throwable.collector=initial.bundles)")
    private ThrowableCollector _throwableCollector;
    private final Map<String, URL> _urls = new ConcurrentHashMap<String, URL>();
    private BundleTracker<Bundle> _wabBundleTracker;

    @Activate
    public void activate(BundleContext bundleContext) {
        try {
            this._activate(bundleContext);
        }
        catch (Throwable t) {
            this._throwableCollector.collect(t);
        }
    }

    public List<Bundle> deploy(BundleContext bundleContext, File lpkgFile) throws IOException {
        Path lpkgFilePath = (lpkgFile = lpkgFile.getCanonicalFile()).toPath();
        if (!lpkgFilePath.startsWith(this._deploymentDirPath)) {
            throw new LPKGVerifyException(StringBundler.concat((String[])new String[]{"Unable to deploy ", String.valueOf(lpkgFile), " from outside the deployment directory ", String.valueOf(this._deploymentDirPath)}));
        }
        List oldBundles = this._lpkgVerifier.verify(lpkgFile);
        for (Bundle bundle : oldBundles) {
            try {
                String location;
                bundle.uninstall();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Uninstalled older LPKG bundle ", String.valueOf(bundle), " in order to install ", String.valueOf(lpkgFile)}));
                }
                if ((location = bundle.getLocation()).equals(lpkgFile.getCanonicalPath()) || !Files.deleteIfExists(Paths.get(bundle.getLocation(), new String[0])) || !_log.isInfoEnabled()) continue;
                _log.info((Object)("Removed old LPKG bundle " + bundle.getLocation()));
            }
            catch (BundleException be) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to uninstall ", String.valueOf(bundle), " in order to install ", String.valueOf(lpkgFile)}), (Throwable)be);
            }
        }
        try {
            String location = lpkgFile.getCanonicalPath();
            Bundle lpkgBundle = bundleContext.getBundle(location);
            if (lpkgBundle != null) {
                return Collections.emptyList();
            }
            ArrayList<Bundle> bundles = new ArrayList<Bundle>();
            lpkgBundle = bundleContext.installBundle(location, this.toBundle(lpkgFile));
            if (lpkgBundle.getState() == 1) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skipped deployment of outdated LPKG " + lpkgFile));
                }
                return bundles;
            }
            BundleStartLevel bundleStartLevel = (BundleStartLevel)lpkgBundle.adapt(BundleStartLevel.class);
            bundleStartLevel.setStartLevel(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL);
            bundles.add(lpkgBundle);
            List newBundles = (List)this._lpkgBundleTracker.getObject(lpkgBundle);
            if (newBundles != null) {
                bundles.addAll(newBundles);
            }
            if (LPKGIndexValidatorThreadLocal.isEnabled()) {
                this._lpkgIndexValidator.updateIntegrityProperties();
            }
            if (!oldBundles.isEmpty()) {
                FrameworkEvent frameworkEvent;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Start refreshing references to point to the new bundle " + lpkgBundle));
                }
                if ((frameworkEvent = this._refreshRemovalPendingBundles(bundleContext)).getType() == 4) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Finished refreshing references to point to the new bundle " + lpkgBundle));
                    }
                } else {
                    throw new Exception(StringBundler.concat((String[])new String[]{"Unable to refresh references to the new bundle ", String.valueOf(lpkgBundle), " because of framework event ", String.valueOf(frameworkEvent)}), frameworkEvent.getThrowable());
                }
            }
            return bundles;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Map<Bundle, List<Bundle>> getDeployedLPKGBundles() {
        return this._lpkgBundleTracker.getTracked();
    }

    public InputStream toBundle(File lpkgFile) throws IOException {
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (ZipFile zipFile = new ZipFile(lpkgFile);
                 JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                String name = lpkgFile.getName();
                this._writeManifest(zipFile, jarOutputStream, name.substring(0, name.length() - 5));
                Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    jarOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    StreamUtil.transfer((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)jarOutputStream, (boolean)false);
                    jarOutputStream.closeEntry();
                }
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        this._lpkgBundleTracker.close();
        this._wabBundleTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _activate(BundleContext bundleContext) throws Exception {
        FrameworkEvent frameworkEvent;
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("url.handler.protocol", new String[]{"lpkg"});
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new LPKGURLStreamHandlerService(this._urls), (Dictionary)properties);
        this._wabBundleTracker = new BundleTracker(bundleContext, -2, (BundleTrackerCustomizer)new WABWrapperBundleTrackerCustomizer(bundleContext));
        this._wabBundleTracker.open();
        this._deploymentDirPath = this._getDeploymentDirPath(bundleContext);
        Path overrideDirPath = this._deploymentDirPath.resolve("override");
        List<File> jarFiles = this._scanFiles(overrideDirPath, ".jar", true);
        this._uninstallOrphanOverridingJars(bundleContext, jarFiles);
        List<File> warFiles = this._scanFiles(overrideDirPath, ".war", true);
        this._uninstallOrphanOverridingWars(bundleContext, warFiles);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Start refreshing uninstalled orphan bundles");
        }
        if ((frameworkEvent = this._refreshRemovalPendingBundles(bundleContext)).getType() == 4) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Finished refreshing uninstalled orphan bundles");
            }
        } else {
            throw new Exception("Unable to refresh uninstalled orphan bundles because of framework event " + frameworkEvent, frameworkEvent.getThrowable());
        }
        this._lpkgBundleTracker = new BundleTracker(bundleContext, -2, (BundleTrackerCustomizer)new LPKGBundleTrackerCustomizer(bundleContext, this._urls, this._toFileNames(jarFiles, warFiles)));
        this._lpkgBundleTracker.open();
        List<File> lpkgFiles = this._scanFiles(this._deploymentDirPath, ".lpkg", false);
        this._lpkgIndexValidator.setLPKGDeployer(this);
        this._lpkgIndexValidator.setJarFiles(jarFiles);
        if (lpkgFiles.isEmpty()) {
            return;
        }
        boolean updateIntegrityProperties = this._lpkgIndexValidator.validate(lpkgFiles);
        boolean enabled = LPKGIndexValidatorThreadLocal.isEnabled();
        LPKGIndexValidatorThreadLocal.setEnabled(false);
        try {
            this._instalLPKGs(bundleContext, lpkgFiles);
            this._installOverrideJars(bundleContext, jarFiles);
            this._installOverrideWars(bundleContext, warFiles);
            if (updateIntegrityProperties) {
                this._lpkgIndexValidator.updateIntegrityProperties();
            }
        }
        finally {
            LPKGIndexValidatorThreadLocal.setEnabled(enabled);
        }
    }

    private Path _getDeploymentDirPath(BundleContext bundleContext) throws IOException {
        File deploymentDir = new File(GetterUtil.getString((String)bundleContext.getProperty("lpkg.deployer.dir"), (String)PropsValues.MODULE_FRAMEWORK_MARKETPLACE_DIR));
        deploymentDir = deploymentDir.getCanonicalFile();
        Path deploymentDirPath = deploymentDir.toPath();
        Files.createDirectories(deploymentDirPath, new FileAttribute[0]);
        return deploymentDirPath;
    }

    private void _installOverrideJars(BundleContext bundleContext, List<File> jarFiles) throws Exception {
        for (File jarFile : jarFiles) {
            String location = _LPKG_OVERRIDE_PREFIX.concat(jarFile.getCanonicalPath());
            Bundle jarBundle = bundleContext.getBundle(location);
            if (jarBundle != null) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Using overriding JAR bundle " + location));
                continue;
            }
            jarBundle = bundleContext.installBundle(location, (InputStream)new FileInputStream(jarFile));
            BundleStartLevelUtil.setStartLevelAndStart((Bundle)jarBundle, (int)PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL, (BundleContext)bundleContext);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Installed override JAR bundle " + location));
        }
    }

    private void _installOverrideWars(BundleContext bundleContext, List<File> warFiles) throws Exception {
        Properties properties = this._loadOverrideWarsProperties(bundleContext);
        Path osgiWarDir = Paths.get(PropsValues.MODULE_FRAMEWORK_WAR_DIR, new String[0]);
        boolean modified = false;
        for (File warFile : warFiles) {
            String sourceLocation = warFile.getCanonicalPath();
            String targetLocation = properties.getProperty(sourceLocation);
            if (targetLocation != null) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Using overridding WAR bundle " + targetLocation));
                continue;
            }
            Path sourceWarPath = warFile.toPath();
            Path targetWarPath = osgiWarDir.resolve(sourceWarPath.getFileName());
            Files.copy(sourceWarPath, targetWarPath, StandardCopyOption.REPLACE_EXISTING);
            targetLocation = targetWarPath.toString();
            properties.put(sourceLocation, targetLocation);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deployed override WAR bundle to " + targetLocation));
            }
            modified = true;
        }
        if (modified) {
            this._saveOverrideWarsProperties(bundleContext, properties);
        }
    }

    private void _instalLPKGs(BundleContext bundleContext, List<File> lpkgFiles) {
        for (File lpkgFile : lpkgFiles) {
            try {
                List<Bundle> bundles = this.deploy(bundleContext, lpkgFile);
                if (bundles.isEmpty()) continue;
                Bundle lpkgBundle = bundles.get(0);
                lpkgBundle.start();
            }
            catch (Exception e) {
                _log.error((Object)("Unable to deploy LPKG file " + lpkgFile), (Throwable)e);
            }
        }
    }

    private Properties _loadOverrideWarsProperties(BundleContext bundleContext) throws IOException {
        Bundle bundle = bundleContext.getBundle(0L);
        BundleContext systemBundleContext = bundle.getBundleContext();
        File overrideWarsPropertiesFile = systemBundleContext.getDataFile("override-wars.properties");
        Properties overrideWarsProperties = new Properties();
        if (overrideWarsPropertiesFile.exists()) {
            try (FileInputStream inputStream = new FileInputStream(overrideWarsPropertiesFile);){
                overrideWarsProperties.load(inputStream);
            }
        }
        return overrideWarsProperties;
    }

    private FrameworkEvent _refreshRemovalPendingBundles(BundleContext bundleContext) throws Exception {
        Bundle systemBundle = bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(null, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        return (FrameworkEvent)defaultNoticeableFuture.get();
    }

    private void _saveOverrideWarsProperties(BundleContext bundleContext, Properties properties) throws IOException {
        Bundle bundle = bundleContext.getBundle(0L);
        BundleContext systemBundleContext = bundle.getBundleContext();
        File overrideWarsPropertiesFile = systemBundleContext.getDataFile("override-wars.properties");
        try (FileOutputStream outputStream = new FileOutputStream(overrideWarsPropertiesFile);){
            properties.store(outputStream, null);
        }
    }

    private List<File> _scanFiles(Path dirPath, String extension, boolean checkFileName) throws IOException {
        if (Files.notExists(dirPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath);){
            for (Path path : directoryStream) {
                Matcher matcher;
                String pathName = StringUtil.toLowerCase((String)String.valueOf(path.getFileName()));
                if (!pathName.endsWith(extension)) continue;
                if (checkFileName && (matcher = _pattern.matcher(pathName)).matches()) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Override file " + path + " has an invalid name and will be ignored"));
                    continue;
                }
                files.add(path.toFile());
            }
        }
        return files;
    }

    private Set<String> _toFileNames(List<File> jarFiles, List<File> warFiles) {
        HashSet<String> fileNames = new HashSet<String>();
        for (File file : jarFiles) {
            fileNames.add(StringUtil.toLowerCase((String)file.getName()));
        }
        for (File file : warFiles) {
            fileNames.add(StringUtil.toLowerCase((String)file.getName()));
        }
        return fileNames;
    }

    private void _uninstallOrphanOverridingJars(BundleContext bundleContext, List<File> jarFiles) throws BundleException {
        for (Bundle bundle : bundleContext.getBundles()) {
            String filePath;
            String location = bundle.getLocation();
            if (!location.startsWith(_LPKG_OVERRIDE_PREFIX) || jarFiles.contains(new File(filePath = location.substring(_LPKG_OVERRIDE_PREFIX.length())))) continue;
            bundle.uninstall();
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Uninstalled orphan overriding JAR bundle " + location));
        }
    }

    private void _uninstallOrphanOverridingWars(BundleContext bundleContext, List<File> warFiles) throws IOException {
        Properties properties = this._loadOverrideWarsProperties(bundleContext);
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entrySet.iterator();
        boolean modified = false;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (warFiles.contains(new File((String)entry.getKey()))) continue;
            iterator.remove();
            Files.deleteIfExists(Paths.get((String)entry.getValue(), new String[0]));
            modified = true;
        }
        if (modified) {
            this._saveOverrideWarsProperties(bundleContext, properties);
        }
    }

    private void _writeManifest(ZipFile zipFile, JarOutputStream jarOutputStream, String symbolicName) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        Properties properties = new Properties();
        properties.load(zipFile.getInputStream(zipFile.getEntry("liferay-marketplace.properties")));
        attributes.putValue("Bundle-Description", properties.getProperty("description"));
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", symbolicName);
        attributes.putValue("Bundle-Version", properties.getProperty("version"));
        attributes.putValue("Liferay-Releng-Bundle-Type", "lpkg");
        attributes.putValue("Manifest-Version", "2");
        jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(jarOutputStream);
        jarOutputStream.closeEntry();
    }
}

