/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.lpkg.StaticLPKGResolver;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lpkg.deployer.internal.LPKGInnerBundleLocationUtil;
import com.liferay.portal.lpkg.deployer.internal.WABWrapperUtil;
import com.liferay.portal.lpkg.deployer.internal.wrapper.bundle.URLStreamHandlerServiceServiceTrackerCustomizer;
import com.liferay.portal.lpkg.deployer.internal.wrapper.bundle.WARBundleWrapperBundleActivator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.url.URLConstants;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LPKGBundleTrackerCustomizer
implements BundleTrackerCustomizer<List<Bundle>> {
    private static final String _MARKER_FILE = ".lfr-outdated";
    private static final Log _log = LogFactoryUtil.getLog(LPKGBundleTrackerCustomizer.class);
    private static final List<String> _staticLPKGBundleSymbolicNames = StaticLPKGResolver.getStaticLPKGBundleSymbolicNames();
    private final BundleContext _bundleContext;
    private final Set<String> _outdatedRemoteAppIds = new HashSet<String>();
    private final Set<String> _overrideFileNames;
    private final Map<String, URL> _urls;

    public LPKGBundleTrackerCustomizer(BundleContext bundleContext, Map<String, URL> urls, Set<String> overrideFileNames) {
        this._bundleContext = bundleContext;
        this._urls = urls;
        this._overrideFileNames = overrideFileNames;
    }

    public List<Bundle> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        if (bundle.getEntry(_MARKER_FILE) != null) {
            try {
                bundle.uninstall();
            }
            catch (BundleException be) {
                _log.error((Object)("Unable to uninstall LPKG " + bundle), (Throwable)be);
            }
            return null;
        }
        try {
            Properties properties = LPKGBundleTrackerCustomizer._readMarketplaceProperties(bundle);
            if (properties == null) {
                return null;
            }
            if (this._outdatedRemoteAppIds.contains(properties.getProperty("remote-app-id"))) {
                this._processOutdatedBundle(bundle);
                return null;
            }
            String supersedesRemoteAppIds = properties.getProperty("supersedes-remote-app-ids");
            if (supersedesRemoteAppIds != null) {
                Collections.addAll(this._outdatedRemoteAppIds, StringUtil.split((String)supersedesRemoteAppIds, (char)','));
                for (Bundle installedBundle : this._bundleContext.getBundles()) {
                    properties = LPKGBundleTrackerCustomizer._readMarketplaceProperties(installedBundle);
                    if (properties == null || !this._outdatedRemoteAppIds.contains(properties.getProperty("remote-app-id"))) continue;
                    this._processOutdatedBundle(installedBundle);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to determine if LPKG " + bundle + " is outdated"), (Throwable)e);
        }
        String symbolicName = bundle.getSymbolicName();
        if (_staticLPKGBundleSymbolicNames.contains(symbolicName)) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        File file = new File(bundle.getLocation());
        try (ZipFile zipFile = new ZipFile(file);){
            ArrayList<Bundle> installedBundles = new ArrayList<Bundle>();
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                Bundle newBundle;
                block46: {
                    ZipEntry zipEntry = zipEntries.nextElement();
                    String name = zipEntry.getName();
                    if (!name.endsWith(".jar") && !name.endsWith(".war")) continue;
                    String location = LPKGInnerBundleLocationUtil.generateInnerBundleLocation(bundle, name);
                    StringBundler sb = new StringBundler(4);
                    sb.append("jar:");
                    URI uri = file.toURI();
                    sb.append(URLCodec.decodeURL((String)uri.toString()));
                    sb.append("!/");
                    sb.append(name);
                    URL url = new URL(sb.toString());
                    if (this._isOverridden(symbolicName, url, location)) continue;
                    String servletContextName = null;
                    String lpkgURL = null;
                    if (name.endsWith(".war")) {
                        sb = new StringBundler(10);
                        sb.append("lpkg:/");
                        sb.append(URLCodec.encodeURL((String)bundle.getSymbolicName()));
                        sb.append("-");
                        sb.append((Object)bundle.getVersion());
                        sb.append("/");
                        String[] servletContextNameAndPortalProfileNames = this._readServletContextNameAndPortalProfileNames(url);
                        servletContextName = servletContextNameAndPortalProfileNames[0];
                        sb.append(servletContextName);
                        sb.append(".war");
                        String portalProfileNames = servletContextNameAndPortalProfileNames[1];
                        if (Validator.isNotNull((String)portalProfileNames)) {
                            sb.append("?");
                            sb.append("liferay-portal-profile-names=");
                            sb.append(portalProfileNames);
                        }
                        lpkgURL = sb.toString();
                        this._urls.put(lpkgURL, url);
                    }
                    if ((newBundle = this._bundleContext.getBundle(location)) != null) {
                        bundles.add(newBundle);
                        continue;
                    }
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Throwable throwable = null;
                    try {
                        if (name.endsWith("jar")) {
                            if (this._isBundleInstalled(bundle, url, location)) continue;
                            newBundle = this._bundleContext.installBundle(location, inputStream);
                            break block46;
                        }
                        if (!name.endsWith("war")) break block46;
                        newBundle = this._bundleContext.installBundle(location, this._toWARWrapperBundle(bundle, url, servletContextName, lpkgURL));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                        continue;
                    }
                }
                if (newBundle.getState() == 1) continue;
                bundles.add(newBundle);
                installedBundles.add(newBundle);
            }
            for (Bundle installedBundle : installedBundles) {
                BundleStartLevelUtil.setStartLevelAndStart((Bundle)installedBundle, (int)PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL, (BundleContext)this._bundleContext);
            }
        }
        catch (Throwable t) {
            _log.error((Object)("Rollback bundle installation for " + bundles), t);
            for (Bundle newBundle : bundles) {
                try {
                    newBundle.uninstall();
                }
                catch (BundleException be) {
                    _log.error((Object)("Unable to uninstall bundle " + newBundle), (Throwable)be);
                }
            }
            return null;
        }
        return bundles;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<Bundle> bundles) {
        if (bundle.getState() != 4 || bundleEvent.getType() != 32) {
            return;
        }
        try {
            Object newBundles = this.addingBundle(bundle, bundleEvent);
            if (newBundles != null) {
                bundles.removeAll((Collection<?>)newBundles);
            }
            for (Bundle installedBundle : bundles) {
                if (installedBundle.getState() == 1) continue;
                installedBundle.uninstall();
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)StringBundler.concat((String[])new String[]{"Uninstalled ", String.valueOf(installedBundle), "because ", String.valueOf(bundle), " was updated"}));
            }
            bundles.clear();
            if (newBundles != null) {
                bundles.addAll((Collection<Bundle>)newBundles);
            }
            for (Bundle installedBundle : bundles) {
                Dictionary headers;
                String fragmentHost;
                if (installedBundle.getState() != 4 || (fragmentHost = (String)(headers = installedBundle.getHeaders("")).get("Fragment-Host")) != null) continue;
                installedBundle.start();
            }
        }
        catch (Exception e) {
            _log.error((Object)("Rollback bundle refresh for " + bundles), (Throwable)e);
            for (Bundle newBundle : bundles) {
                try {
                    newBundle.uninstall();
                }
                catch (BundleException be) {
                    _log.error((Object)("Unable to uninstall bundle " + newBundle), (Throwable)be);
                }
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<Bundle> bundles) {
        if (bundle.getState() != 1) {
            return;
        }
        String lpkgBundleSymbolicName = bundle.getSymbolicName();
        String prefix = lpkgBundleSymbolicName.concat("-");
        for (Bundle newBundle : bundles) {
            try {
                this._uninstallBundle(prefix, newBundle);
            }
            catch (Throwable t) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to uninstall ", String.valueOf(newBundle), " in response to uninstallation of ", String.valueOf(bundle)}), t);
            }
        }
    }

    private static Properties _readMarketplaceProperties(Bundle bundle) throws IOException {
        URL url = bundle.getEntry("liferay-marketplace.properties");
        if (url == null) {
            return null;
        }
        try (InputStream in = url.openStream();){
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private String _buildImportPackageString(Class<?> ... classes) {
        StringBundler sb = new StringBundler(classes.length * 2);
        for (Class<?> clazz : classes) {
            Package pkg = clazz.getPackage();
            sb.append(pkg.getName());
            sb.append(",");
        }
        int index = sb.index();
        if (index > 0) {
            sb.setIndex(index - 1);
        }
        return sb.toString();
    }

    private String _extractFileName(String string) {
        int endIndex = string.lastIndexOf(45);
        int beginIndex = string.lastIndexOf(47, endIndex) + 1;
        String name = string.substring(beginIndex, endIndex);
        return name.concat(string.substring(string.length() - 4));
    }

    private boolean _isBundleInstalled(Bundle bundle, URL url, String location) throws IOException {
        try (InputStream inputStream = url.openStream();
             JarInputStream jarInputStream = new JarInputStream(inputStream);){
            Manifest manifest = jarInputStream.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String symbolicName = attributes.getValue("Bundle-SymbolicName");
            Version version = new Version(attributes.getValue("Bundle-Version"));
            for (Bundle installedBundle : this._bundleContext.getBundles()) {
                if (!symbolicName.equals(installedBundle.getSymbolicName()) || !version.equals((Object)installedBundle.getVersion()) || location.equals(installedBundle.getLocation())) continue;
                if (_log.isInfoEnabled()) {
                    StringBundler sb = new StringBundler(7);
                    sb.append("Skipping installation of ");
                    sb.append(symbolicName);
                    sb.append(" with version ");
                    sb.append(version.toString());
                    sb.append(" in ");
                    sb.append(bundle.getSymbolicName());
                    sb.append(" because an identical bundle exists");
                    _log.info((Object)sb.toString());
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean _isOverridden(String symbolicName, URL url, String location) throws Throwable {
        if (this._overrideFileNames.isEmpty()) {
            return false;
        }
        String path = url.getPath();
        String name = this._extractFileName(path);
        if (this._overrideFileNames.contains(name = StringUtil.toLowerCase((String)name))) {
            Bundle bundle = this._bundleContext.getBundle(location);
            if (bundle != null) {
                this._uninstallBundle(symbolicName.concat("-"), bundle);
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Disabled ", symbolicName, ":", url.getPath()}));
            }
            return true;
        }
        return false;
    }

    private void _processOutdatedBundle(Bundle bundle) throws Exception {
        Path path = Paths.get(bundle.getLocation(), new String[0]);
        try (FileSystem fileSystem = FileSystems.newFileSystem(path, null);){
            Files.createFile(fileSystem.getPath(_MARKER_FILE, new String[0]), new FileAttribute[0]);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Uninstalling outdated bundle " + bundle));
        }
        bundle.uninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] _readServletContextNameAndPortalProfileNames(URL url) throws IOException {
        String pathString = url.getPath();
        String servletContextName = pathString.substring(pathString.lastIndexOf(47) + 1, pathString.lastIndexOf(".war"));
        int index = servletContextName.lastIndexOf(45);
        if (index >= 0) {
            servletContextName = servletContextName.substring(0, index);
        }
        String portalProfileNames = null;
        Path tempFilePath = Files.createTempFile(null, null, new FileAttribute[0]);
        try (InputStream inputStream1 = url.openStream();){
            Files.copy(inputStream1, tempFilePath, StandardCopyOption.REPLACE_EXISTING);
            try (ZipFile zipFile = new ZipFile(tempFilePath.toFile());
                 InputStream inputStream2 = zipFile.getInputStream(new ZipEntry("WEB-INF/liferay-plugin-package.properties"));){
                if (inputStream2 != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream2);
                    String configuredServletContextName = properties.getProperty("servlet-context-name");
                    if (configuredServletContextName != null) {
                        servletContextName = configuredServletContextName;
                    }
                    portalProfileNames = properties.getProperty("liferay-portal-profile-names");
                }
            }
        }
        finally {
            Files.delete(tempFilePath);
        }
        return new String[]{servletContextName, portalProfileNames};
    }

    private InputStream _toWARWrapperBundle(Bundle bundle, URL url, String servletContextName, String lpkgURL) throws IOException {
        String pathString = url.getPath();
        String fileName = pathString.substring(pathString.lastIndexOf(47) + 1, pathString.lastIndexOf(".war"));
        String version = String.valueOf(bundle.getVersion());
        int index = fileName.lastIndexOf(45);
        if (index >= 0) {
            version = fileName.substring(index + 1);
        }
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                this._writeManifest(bundle, servletContextName, version, lpkgURL, jarOutputStream);
                this._writeClasses(jarOutputStream, BundleStartLevelUtil.class, WABWrapperUtil.class, WARBundleWrapperBundleActivator.class, URLStreamHandlerServiceServiceTrackerCustomizer.class);
            }
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
            return unsyncByteArrayInputStream;
        }
    }

    private void _uninstallBundle(String prefix, Bundle bundle) throws Throwable {
        if (bundle.getState() == 1) {
            return;
        }
        String symbolicName = bundle.getSymbolicName();
        HashSet<Bundle> uninstalledBundles = new HashSet<Bundle>();
        Dictionary headers = bundle.getHeaders("");
        if (symbolicName.startsWith(prefix) && Boolean.valueOf((String)headers.get("Wrapper-Bundle")).booleanValue()) {
            String wrappedBundleSymbolicName = symbolicName.substring(prefix.length(), symbolicName.length() - 8);
            Version version = bundle.getVersion();
            for (Bundle curBundle : this._bundleContext.getBundles()) {
                if (!wrappedBundleSymbolicName.equals(curBundle.getSymbolicName()) || !version.equals((Object)curBundle.getVersion())) continue;
                curBundle.uninstall();
                uninstalledBundles.add(curBundle);
            }
        }
        bundle.uninstall();
        uninstalledBundles.add(bundle);
        Bundle systemBundle = this._bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(uninstalledBundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        FrameworkEvent frameworkEvent = (FrameworkEvent)defaultNoticeableFuture.get();
        if (frameworkEvent.getType() != 4) {
            throw frameworkEvent.getThrowable();
        }
    }

    private void _writeClasses(JarOutputStream jarOutputStream, Class<?> ... classes) throws IOException {
        for (Class<?> clazz : classes) {
            String className = clazz.getName();
            String path = StringUtil.replace((String)className, (char)'.', (char)'/');
            String resourcePath = path.concat(".class");
            jarOutputStream.putNextEntry(new ZipEntry(resourcePath));
            ClassLoader classLoader = clazz.getClassLoader();
            StreamUtil.transfer((InputStream)classLoader.getResourceAsStream(resourcePath), (OutputStream)jarOutputStream, (boolean)false);
            jarOutputStream.closeEntry();
        }
    }

    private void _writeManifest(Bundle bundle, String contextName, String version, String lpkgURL, JarOutputStream jarOutputStream) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Bundle-Activator", WARBundleWrapperBundleActivator.class.getName());
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", StringBundler.concat((String[])new String[]{bundle.getSymbolicName(), "-", contextName, "-wrapper"}));
        attributes.putValue("Bundle-Version", version);
        attributes.putValue("Import-Package", this._buildImportPackageString(BundleActivator.class, BundleStartLevel.class, ServiceTrackerCustomizer.class, StringBundler.class, URLConstants.class));
        attributes.putValue("Liferay-WAB-Context-Name", contextName);
        attributes.putValue("Liferay-WAB-LPKG-URL", lpkgURL);
        attributes.putValue("Liferay-WAB-Start-Level", String.valueOf(PropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL));
        attributes.putValue("Manifest-Version", "2");
        attributes.putValue("Wrapper-Bundle", "true");
        jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(jarOutputStream);
        jarOutputStream.closeEntry();
    }
}

