/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lpkg.deployer.internal;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lpkg.deployer.LPKGVerifier;
import com.liferay.portal.lpkg.deployer.LPKGVerifyException;
import com.liferay.portal.lpkg.deployer.internal.LPKGIndexValidator;
import com.liferay.portal.lpkg.deployer.internal.LPKGIndexValidatorThreadLocal;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LPKGVerifier.class})
public class DefaultLPKGVerifier
implements LPKGVerifier {
    private BundleContext _bundleContext;
    @Reference
    private LPKGIndexValidator _lpkgIndexValidator;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Bundle> verify(File lpkgFile) {
        try (ZipFile zipFile = new ZipFile(lpkgFile);){
            ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
            if (zipEntry == null) {
                throw new LPKGVerifyException(lpkgFile + " does not have liferay-marketplace.properties");
            }
            Properties properties = new Properties();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                properties.load(inputStream);
            }
            String symbolicName = lpkgFile.getName();
            symbolicName = symbolicName.substring(0, symbolicName.length() - 5);
            if (Validator.isNull((String)symbolicName)) {
                throw new LPKGVerifyException(lpkgFile + " does not have a valid symbolic name");
            }
            Version version = null;
            String versionString = properties.getProperty("version");
            try {
                version = new Version(versionString);
            }
            catch (IllegalArgumentException iae) {
                throw new LPKGVerifyException(lpkgFile + " does not have a valid version: " + versionString, (Throwable)iae);
            }
            if (LPKGIndexValidatorThreadLocal.isEnabled()) {
                this._lpkgIndexValidator.validate(Collections.singletonList(lpkgFile));
            }
            ArrayList<Bundle> oldBundles = new ArrayList<Bundle>();
            for (Bundle bundle : this._bundleContext.getBundles()) {
                if (!symbolicName.equals(bundle.getSymbolicName())) continue;
                int value = version.compareTo(bundle.getVersion());
                if (value != 0) {
                    oldBundles.add(bundle);
                    continue;
                }
                String path = lpkgFile.getCanonicalPath();
                if ((path = StringUtil.replace((String)path, (char)'\\', (char)'/')).equals(bundle.getLocation())) continue;
                throw new LPKGVerifyException(StringBundler.concat((String[])new String[]{"Existing LPKG bundle ", String.valueOf(bundle), " has the same symbolic name and version as LPKG ", "file ", path}));
            }
            ArrayList<Bundle> arrayList = oldBundles;
            return arrayList;
        }
        catch (Exception e) {
            throw new LPKGVerifyException((Throwable)e);
        }
    }
}

