/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.log4j.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;

public class Log4jExtender
implements BundleActivator {
    private static final Logger _logger = Logger.getLogger(Log4jExtender.class);
    private volatile BundleTracker<Void> _tracker;

    public void start(BundleContext bundleContext) throws Exception {
        this._tracker = new BundleTracker<Void>(bundleContext, 32, null){

            public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                try {
                    Log4jExtender.this._configureLog4j(bundle, "META-INF/module-log4j.xml");
                    Log4jExtender.this._configureLog4j(bundle, "META-INF/module-log4j-ext.xml");
                    Log4jExtender.this._configureLog4j(bundle.getSymbolicName());
                }
                catch (IOException ioe) {
                    _logger.error((Object)("Unable to configure Log4j for bundle " + bundle.getSymbolicName()), (Throwable)ioe);
                }
                return null;
            }
        };
        this._tracker.open();
    }

    public void stop(BundleContext context) {
        this._tracker.close();
    }

    private void _configureLog4j(Bundle bundle, String resourcePath) throws IOException {
        Enumeration enumeration = bundle.getResources(resourcePath);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DOMConfigurator domConfigurator = new DOMConfigurator();
                domConfigurator.doConfigure((URL)enumeration.nextElement(), LogManager.getLoggerRepository());
            }
        }
    }

    private void _configureLog4j(String symbolicName) throws MalformedURLException {
        File configFile = new File(StringBundler.concat((String[])new String[]{PropsValues.MODULE_FRAMEWORK_BASE_DIR, "/log4j/", symbolicName, "-log4j-ext.xml"}));
        if (!configFile.exists()) {
            return;
        }
        DOMConfigurator domConfigurator = new DOMConfigurator();
        URI uri = configFile.toURI();
        domConfigurator.doConfigure(uri.toURL(), LogManager.getLoggerRepository());
    }
}

