/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.k8s.agent.internal.scheduler;

import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.k8s.agent.custodian.VirtualInstanceCustodian;
import com.liferay.portal.k8s.agent.internal.model.listener.VirtualHostModelListener;
import com.liferay.portal.k8s.agent.internal.util.CompanyConfigMapUtil;
import com.liferay.portal.kernel.model.CompanyModel;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SchedulerJobConfiguration.class})
public class VirtualHostSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final Snapshot<PortalK8sConfigMapModifier> _portalK8sConfigMapModifierSnapshot = new Snapshot(VirtualHostModelListener.class, PortalK8sConfigMapModifier.class, null, true);
    private static final Snapshot<VirtualInstanceCustodian> _virtualInstanceCustodianSnapshot = new Snapshot(VirtualHostModelListener.class, VirtualInstanceCustodian.class, null, true);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private VirtualHostLocalService _virtualHostLocalService;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            List companies = this._companyLocalService.getCompanies();
            VirtualInstanceCustodian virtualInstanceCustodian = (VirtualInstanceCustodian)_virtualInstanceCustodianSnapshot.get();
            virtualInstanceCustodian.clean(ListUtil.toList((List)companies, CompanyModel::getWebId));
            companies.forEach(company -> CompanyConfigMapUtil.modifyConfigMap(company, (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get(), this._virtualHostLocalService));
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)2, (TimeUnit)TimeUnit.MINUTE);
    }
}

