/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.k8s.agent.internal.mutator;

import com.liferay.portal.k8s.agent.mutator.PortalK8sConfigurationPropertiesMutator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceRanking;

@Component(service={PortalK8sConfigurationPropertiesMutator.class})
@ServiceRanking(value=1800)
public class BaseURLPortalK8sConfigurationPropertiesMutator
implements PortalK8sConfigurationPropertiesMutator {
    private static final Log _log = LogFactoryUtil.getLog(BaseURLPortalK8sConfigurationPropertiesMutator.class);
    @Reference
    private CompanyLocalService _companyLocalService;

    public void mutateConfigurationProperties(Map<String, String> annotations, Map<String, String> labels, Dictionary<String, Object> properties) {
        String mainDomain = this._getMainDomain(annotations, labels);
        if (Validator.isNotNull((String)mainDomain)) {
            properties.put("baseURL", "$[conf:.serviceScheme]://$[conf:.serviceAddress]");
            properties.put(".serviceAddress", mainDomain);
            properties.put(".serviceScheme", GetterUtil.getString((String)PropsValues.WEB_SERVER_PROTOCOL, (String)"https"));
        }
    }

    private String _getMainDomain(Map<String, String> annotations, Map<String, String> labels) {
        String mainDomain = annotations.get("ext.lxc.liferay.com/mainDomain");
        if (Validator.isNotNull((String)mainDomain)) {
            return mainDomain;
        }
        String virtualInstanceId = labels.get("dxp.lxc.liferay.com/virtualInstanceId");
        if (Validator.isNotNull((String)virtualInstanceId)) {
            try {
                Company company = this._companyLocalService.getCompanyByWebId(virtualInstanceId);
                return company.getVirtualHostname();
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return null;
    }
}

