/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.k8s.agent.internal.model.listener;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.k8s.agent.internal.thread.local.AgentPortalK8sThreadLocal;
import com.liferay.portal.k8s.agent.internal.util.CompanyConfigMapUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class VirtualHostModelListener
extends BaseModelListener<VirtualHost> {
    private static final Log _log = LogFactoryUtil.getLog(VirtualHostModelListener.class);
    private static final Snapshot<PortalK8sConfigMapModifier> _portalK8sConfigMapModifierSnapshot = new Snapshot(VirtualHostModelListener.class, PortalK8sConfigMapModifier.class, null, true);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private VirtualHostLocalService _virtualHostLocalService;

    public void onAfterCreate(VirtualHost virtualHost) {
        Company company = this._companyLocalService.fetchCompanyById(virtualHost.getCompanyId());
        if (company == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Created virtual host ", virtualHost.getHostname(), " for company ", company.getWebId()}));
        }
        PortalK8sConfigMapModifier portalK8sConfigMapModifier = (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get();
        try (SafeCloseable safeCloseable = AgentPortalK8sThreadLocal.executeOnCurrentNodeWithSafeCloseable();){
            CompanyConfigMapUtil.modifyConfigMap(company, portalK8sConfigMapModifier, this._virtualHostLocalService);
        }
    }

    public void onAfterRemove(VirtualHost virtualHost) throws ModelListenerException {
        Company company = this._companyLocalService.fetchCompanyById(virtualHost.getCompanyId());
        if (company == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Removed virtual host ", virtualHost.getHostname(), " for company ", company.getWebId()}));
        }
        PortalK8sConfigMapModifier portalK8sConfigMapModifier = (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get();
        try (SafeCloseable safeCloseable = AgentPortalK8sThreadLocal.executeOnCurrentNodeWithSafeCloseable();){
            CompanyConfigMapUtil.modifyConfigMap(company, portalK8sConfigMapModifier, this._virtualHostLocalService);
        }
    }

    public void onAfterUpdate(VirtualHost originalVirtualHost, VirtualHost virtualHost) throws ModelListenerException {
        Company company = this._companyLocalService.fetchCompanyById(virtualHost.getCompanyId());
        if (company == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Updated virtual host ", virtualHost.getHostname(), " for company ", company.getWebId()}));
        }
        PortalK8sConfigMapModifier portalK8sConfigMapModifier = (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get();
        try (SafeCloseable safeCloseable = AgentPortalK8sThreadLocal.executeOnCurrentNodeWithSafeCloseable();){
            CompanyConfigMapUtil.modifyConfigMap(company, portalK8sConfigMapModifier, this._virtualHostLocalService);
        }
    }

    @Activate
    protected void activate() {
        PortalK8sConfigMapModifier portalK8sConfigMapModifier = (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get();
        this._companyLocalService.forEachCompany(company -> CompanyConfigMapUtil.modifyConfigMap(company, portalK8sConfigMapModifier, this._virtualHostLocalService));
    }
}

