/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.k8s.agent.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.k8s.agent.custodian.VirtualInstanceCustodian;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalInetSocketAddressEventListener;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=-1"}, service={PortalK8sConfigMapModifier.class, VirtualInstanceCustodian.class})
public class RoutesPortalK8sConfigMapModifier
implements PortalInetSocketAddressEventListener,
PortalK8sConfigMapModifier,
VirtualInstanceCustodian {
    private static final Log _log = LogFactoryUtil.getLog(RoutesPortalK8sConfigMapModifier.class);
    private static final Pattern _lxcDXPMetadataPattern = Pattern.compile("(.*)-lxc-dxp-metadata$");
    private static final Pattern _lxcExtInitMetadataPattern = Pattern.compile("(.*)-lxc-ext-init-metadata$");
    @Reference
    private File _file;
    @Reference
    private Portal _portal;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

    public void clean(List<String> virtualInstanceIds) {
        Path liferayRoutesPath = this._getLiferayRoutesPath();
        if (liferayRoutesPath == null) {
            return;
        }
        java.io.File liferayRoutesFile = liferayRoutesPath.toFile();
        for (String directoryName : FileUtil.listDirs((java.io.File)liferayRoutesFile)) {
            java.io.File routesDirectory;
            if (Objects.equals(directoryName, "default") || virtualInstanceIds.contains(directoryName) || !(routesDirectory = new java.io.File(liferayRoutesFile, directoryName)).exists()) continue;
            FileUtil.deltree((java.io.File)routesDirectory);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Deleted custodian " + directoryName));
        }
    }

    public PortalK8sConfigMapModifier.Result modifyConfigMap(Consumer<PortalK8sConfigMapModifier.ConfigMapModel> configMapModelConsumer, String configMapName) {
        Objects.requireNonNull(configMapModelConsumer, "Config map model consumer is null");
        final TreeMap annotations = new TreeMap();
        final TreeMap binaryData = new TreeMap();
        final TreeMap<String, String> data = new TreeMap<String, String>();
        final TreeMap<String, String> labels = new TreeMap<String, String>();
        configMapModelConsumer.accept(new PortalK8sConfigMapModifier.ConfigMapModel(){

            public Map<String, String> annotations() {
                return annotations;
            }

            public Map<String, String> binaryData() {
                return binaryData;
            }

            public Map<String, String> data() {
                return data;
            }

            public Map<String, String> labels() {
                return labels;
            }
        });
        if (binaryData.isEmpty() && data.isEmpty()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deleting routes for " + configMapName));
            }
            try {
                this._deleteRoutes(configMapName, labels);
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to delete routes for " + configMapName), (Throwable)exception);
            }
            return PortalK8sConfigMapModifier.Result.DELETED;
        }
        try {
            this._writeRoutes(data, labels);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to write routes for " + configMapName), (Throwable)exception);
        }
        return PortalK8sConfigMapModifier.Result.CREATED;
    }

    public void portalLocalInetSocketAddressConfigured(InetSocketAddress localInetSocketAddress, boolean secure) {
        this._updateDXPRoutes(secure);
    }

    public void portalServerInetSocketAddressConfigured(InetSocketAddress serverInetSocketAddress, boolean secure) {
        this._updateDXPRoutes(secure);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistrations.add(bundleContext.registerService(ModelListener.class, (Object)new CompanyModelListener(), null));
        this._serviceRegistrations.add(bundleContext.registerService(PortalInetSocketAddressEventListener.class, (Object)this, null));
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _deleteRoutes(String configMapName, Map<String, String> labels) throws Exception {
        Path liferayRoutesPath = this._getLiferayRoutesPath();
        String virtualInstanceId = labels.get("dxp.lxc.liferay.com/virtualInstanceId");
        if (liferayRoutesPath == null || virtualInstanceId == null) {
            return;
        }
        if (Objects.equals(virtualInstanceId, PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            virtualInstanceId = "default";
        }
        Path virtualInstanceIdPath = liferayRoutesPath.resolve(virtualInstanceId);
        Matcher matcher = _lxcDXPMetadataPattern.matcher(configMapName);
        if (matcher.matches()) {
            this._file.deltree(virtualInstanceIdPath.toFile());
        } else {
            Path projectPath;
            matcher = _lxcExtInitMetadataPattern.matcher(configMapName);
            String projectName = labels.get("ext.lxc.liferay.com/projectName");
            if (matcher.matches() && projectName != null && Files.exists(projectPath = virtualInstanceIdPath.resolve(projectName), new LinkOption[0])) {
                this._file.deltree(projectPath.toFile());
            }
        }
    }

    private Path _getLiferayRoutesPath() {
        Path liferayRoutesPath = Paths.get(PropsValues.LIFERAY_HOME, "routes");
        try {
            liferayRoutesPath = Files.createDirectories(liferayRoutesPath, new FileAttribute[0]);
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to create routes directory", (Throwable)ioException);
        }
        return liferayRoutesPath;
    }

    private int _getPortalLocalPort() {
        return this._portal.getPortalLocalPort(Objects.equals(PropsValues.WEB_SERVER_PROTOCOL, "https"));
    }

    private void _updateDXPRoutes(final boolean secure) {
        try {
            Files.walkFileTree(this._getLiferayRoutesPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (!Objects.equals(String.valueOf(path.getFileName()), "dxp")) {
                        return FileVisitResult.CONTINUE;
                    }
                    HashMap<String, String> data = new HashMap<String, String>();
                    java.io.File dir = path.toFile();
                    for (java.io.File file : dir.listFiles()) {
                        data.put(file.getName(), new String(Files.readAllBytes(file.toPath())));
                    }
                    RoutesPortalK8sConfigMapModifier.this._updatePortalLocalPort(data, RoutesPortalK8sConfigMapModifier.this._portal.getPortalLocalPort(secure));
                    data.forEach((key, value) -> {
                        try {
                            Path keyPath = path.resolve((String)key);
                            RoutesPortalK8sConfigMapModifier.this._file.write(keyPath.toFile(), value.getBytes());
                        }
                        catch (IOException ioException) {
                            ReflectionUtil.throwException((Throwable)ioException);
                        }
                    });
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to update DXP routes", (Throwable)ioException);
        }
    }

    private void _updatePortalLocalPort(Map<String, String> labels, int portalLocalPort) {
        List lxcDXPDomains;
        if (portalLocalPort <= 0) {
            return;
        }
        String lxcDXPMainDomain = labels.getOrDefault("com.liferay.lxc.dxp.main.domain", labels.get("com.liferay.lxc.dxp.mainDomain"));
        if (lxcDXPMainDomain != null && lxcDXPMainDomain.indexOf(58) == -1) {
            labels.put("com.liferay.lxc.dxp.main.domain", lxcDXPMainDomain + ":" + portalLocalPort);
            labels.put("com.liferay.lxc.dxp.mainDomain", lxcDXPMainDomain + ":" + portalLocalPort);
        }
        if ((lxcDXPDomains = StringUtil.split((String)labels.get("com.liferay.lxc.dxp.domains"), (char)'\n')).isEmpty()) {
            return;
        }
        ArrayList<String> updatedLXCDXPDomains = new ArrayList<String>();
        for (String lxcDXPDomain : lxcDXPDomains) {
            if (lxcDXPDomain != null && lxcDXPDomain.indexOf(":") == -1) {
                updatedLXCDXPDomains.add(lxcDXPDomain + ":" + portalLocalPort);
                continue;
            }
            updatedLXCDXPDomains.add(lxcDXPDomain);
        }
        labels.put("com.liferay.lxc.dxp.domains", StringUtil.merge(updatedLXCDXPDomains, (String)"\n"));
    }

    private void _write(Path path, Map<String, String> data) {
        data.forEach((key, value) -> {
            try {
                Path keyPath = path.resolve((String)key);
                this._file.write(keyPath.toFile(), value.getBytes());
            }
            catch (IOException ioException) {
                ReflectionUtil.throwException((Throwable)ioException);
            }
        });
    }

    private void _writeRoutes(Map<String, String> data, Map<String, String> labels) throws Exception {
        Path liferayRoutesPath = this._getLiferayRoutesPath();
        if (liferayRoutesPath == null) {
            return;
        }
        String metadataType = labels.get("lxc.liferay.com/metadataType");
        String virtualInstanceId = labels.get("dxp.lxc.liferay.com/virtualInstanceId");
        if (metadataType == null || virtualInstanceId == null) {
            return;
        }
        if (Objects.equals(virtualInstanceId, PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            virtualInstanceId = "default";
        }
        Path virtualInstanceIdPath = liferayRoutesPath.resolve(virtualInstanceId);
        Files.createDirectories(virtualInstanceIdPath, new FileAttribute[0]);
        if (Objects.equals(metadataType, "dxp")) {
            Path dxpRoutesPath = virtualInstanceIdPath.resolve("dxp");
            Files.createDirectories(dxpRoutesPath, new FileAttribute[0]);
            int portalLocalPort = this._getPortalLocalPort();
            if (portalLocalPort > 0) {
                this._updatePortalLocalPort(data, portalLocalPort);
            }
            this._write(dxpRoutesPath, data);
        } else if (Objects.equals(metadataType, "ext-init")) {
            String projectName = labels.get("ext.lxc.liferay.com/projectName");
            Path projectPath = virtualInstanceIdPath.resolve(projectName);
            Files.createDirectories(projectPath, new FileAttribute[0]);
            this._write(projectPath, data);
        }
    }

    private static class CompanyModelListener
    extends BaseModelListener<Company> {
        private static final Snapshot<PortalK8sConfigMapModifier> _portalK8sConfigMapModifierSnapshot = new Snapshot(CompanyModelListener.class, PortalK8sConfigMapModifier.class, null, true);

        private CompanyModelListener() {
        }

        public void onAfterRemove(Company company) throws ModelListenerException {
            if (Objects.equals(company.getWebId(), PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                return;
            }
            PortalK8sConfigMapModifier portalK8sConfigMapModifier = (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get();
            portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
                Map data = configMapModel.data();
                data.clear();
                Map labels = configMapModel.labels();
                labels.put("dxp.lxc.liferay.com/virtualInstanceId", company.getWebId());
            }, this._getConfigMapName(company));
        }

        private String _getConfigMapName(Company company) {
            return company.getWebId() + "-lxc-dxp-metadata";
        }
    }
}

