/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.NoSuchCompanyException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_instances_web_portlet_PortalInstancesPortlet", "mvc.command.name=/portal_instances/edit_instance"}, service={MVCRenderCommand.class})
public class EditInstanceMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Portal _portal;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.getInstance((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchCompanyException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return "/edit_instance.jsp";
    }

    protected void getInstance(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest(portletRequest);
        long companyId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"companyId");
        Company company = null;
        if (companyId > 0L) {
            company = this._companyLocalService.getCompanyById(companyId);
        }
        httpServletRequest.setAttribute("SEL_COMPANY", company);
    }
}

