/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.web.internal.portlet.action;

import com.liferay.portal.instances.service.PortalInstancesLocalService;
import com.liferay.portal.kernel.exception.CompanyMxException;
import com.liferay.portal.kernel.exception.CompanyVirtualHostException;
import com.liferay.portal.kernel.exception.CompanyWebIdException;
import com.liferay.portal.kernel.exception.NoSuchCompanyException;
import com.liferay.portal.kernel.exception.RequiredCompanyException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_instances_web_portlet_PortalInstancesPortlet", "mvc.command.name=/portal_instances/edit_instance"}, service={MVCActionCommand.class})
public class EditInstanceMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private CompanyService _companyService;
    @Reference
    private PortalInstancesLocalService _portalInstancesLocalService;

    protected void deleteInstance(ActionRequest actionRequest) throws Exception {
        long companyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"companyId");
        this._companyService.deleteCompany(companyId);
        this.synchronizePortalInstances();
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteInstance(actionRequest);
            } else {
                this.updateInstance(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            String mvcPath = "/error.jsp";
            if (e instanceof NoSuchCompanyException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            } else if (e instanceof CompanyMxException || e instanceof CompanyVirtualHostException || e instanceof CompanyWebIdException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                mvcPath = "/edit_instance.jsp";
            } else if (e instanceof RequiredCompanyException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            } else {
                throw e;
            }
            actionResponse.setRenderParameter("mvcPath", mvcPath);
        }
    }

    protected void synchronizePortalInstances() {
        this._portalInstancesLocalService.synchronizePortalInstances();
    }

    protected void updateInstance(ActionRequest actionRequest) throws Exception {
        long companyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"companyId");
        String webId = ParamUtil.getString((PortletRequest)actionRequest, (String)"webId");
        String virtualHostname = ParamUtil.getString((PortletRequest)actionRequest, (String)"virtualHostname");
        String mx = ParamUtil.getString((PortletRequest)actionRequest, (String)"mx");
        boolean system = false;
        int maxUsers = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxUsers", (int)0);
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        if (companyId <= 0L) {
            Company company = this._companyService.addCompany(webId, virtualHostname, mx, system, maxUsers, active);
            ServletContext servletContext = (ServletContext)actionRequest.getAttribute("CTX");
            this._portalInstancesLocalService.initializePortalInstance(servletContext, company.getWebId());
        } else {
            this._companyService.updateCompany(companyId, virtualHostname, mx, maxUsers, active);
        }
        this.synchronizePortalInstances();
    }
}

