/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.inactive.request.handler.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.inactive.request.handler.configuration.InactiveRequestHandlerConfiguration;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.InactiveRequestHandler;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.inactive.request.handler.configuration.InactiveRequestHandlerConfiguration"}, immediate=true, service={InactiveRequestHandler.class})
public class InactiveRequestHandlerImpl
implements InactiveRequestHandler {
    private static final String _INACTIVE_HTML_FILE_NAME = "com/liferay/portal/dependencies/inactive.html";
    private static final Log _log = LogFactoryUtil.getLog(InactiveRequestHandlerImpl.class);
    private String _content = "";
    @Reference
    private Portal _portal;
    private volatile boolean _showInactiveRequestMessage;

    public void processInactiveRequest(HttpServletRequest request, HttpServletResponse response, String messageKey) throws IOException {
        response.setStatus(404);
        PrintWriter printWriter = response.getWriter();
        if (!this._showInactiveRequestMessage) {
            try {
                this._portal.sendError(404, (Exception)new NoSuchLayoutException(), this._portal.getOriginalServletRequest(request), response);
            }
            catch (ServletException se) {
                throw new IOException(se);
            }
            return;
        }
        response.setContentType("text/html; charset=UTF-8");
        Locale locale = this._portal.getLocale(request);
        String message = null;
        message = LanguageUtil.isValidLanguageKey((Locale)locale, (String)messageKey) ? LanguageUtil.get((Locale)locale, (String)messageKey) : HtmlUtil.escape((String)messageKey);
        String html = StringUtil.replace((String)this._content, (String)"[$MESSAGE$]", (String)message);
        printWriter.print(html);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        block16: {
            this.modified(properties);
            Bundle bundle = bundleContext.getBundle();
            URL url = bundle.getResource(_INACTIVE_HTML_FILE_NAME);
            if (url == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to load com/liferay/portal/dependencies/inactive.html");
                }
                return;
            }
            try (InputStream inputStream = url.openStream();){
                this._content = StringUtil.read((InputStream)inputStream);
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block16;
                _log.warn((Object)"Unable to read com/liferay/portal/dependencies/inactive.html", (Throwable)ioe);
            }
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        InactiveRequestHandlerConfiguration inactiveRequestHandlerConfiguration = (InactiveRequestHandlerConfiguration)ConfigurableUtil.createConfigurable(InactiveRequestHandlerConfiguration.class, properties);
        this._showInactiveRequestMessage = inactiveRequestHandlerConfiguration.showInactiveRequestMessage();
    }
}

